/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.architectury.event.events.client.ClientCommandRegistrationEvent;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1132;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_310;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3341;
import net.minecraft.class_3449;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import wiki.minecraft.heywiki.target.Target;
import wiki.minecraft.heywiki.wiki.WikiPage;

public class WhatStructureCommand {
    public static final SimpleCommandExceptionType NO_INTEGRATED_SERVER = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.whatstructure.no_integrated_server"));
    public static final SimpleCommandExceptionType NO_STRUCTURE = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.whatstructure.no_structure"));
    private static final class_310 CLIENT = class_310.method_1551();

    public static LiteralCommandNode<ClientCommandRegistrationEvent.ClientCommandSourceStack> register(CommandDispatcher<ClientCommandRegistrationEvent.ClientCommandSourceStack> dispatcher) {
        return dispatcher.register((LiteralArgumentBuilder)ClientCommandRegistrationEvent.literal((String)"whatstructure").executes(ctx -> {
            if (WhatStructureCommand.CLIENT.field_1724 == null || WhatStructureCommand.CLIENT.field_1687 == null) {
                return -1;
            }
            class_2338 block = WhatStructureCommand.CLIENT.field_1724.method_24515();
            if (!CLIENT.method_1496()) {
                throw NO_INTEGRATED_SERVER.create();
            }
            class_1132 server = CLIENT.method_1576();
            UUID playerUuid = WhatStructureCommand.CLIENT.field_1724.method_5667();
            class_3324 playerManager = Objects.requireNonNull(server).method_3760();
            class_3222 serverPlayer = playerManager.method_14602(playerUuid);
            class_3218 serverWorld = Objects.requireNonNull(serverPlayer).method_51469();
            class_1923 chunkPos = new class_1923(block);
            class_2791 chunk = serverWorld.method_8402(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_16422, false);
            if (chunk == null) {
                return -1;
            }
            Map references = chunk.method_12179();
            for (Map.Entry entry : references.entrySet()) {
                class_3195 structure = (class_3195)entry.getKey();
                LongSet positions = (LongSet)entry.getValue();
                class_1923 startChunkPos = new class_1923(positions.toLongArray()[0]);
                class_2791 startChunk = serverWorld.method_8402(startChunkPos.field_9181, startChunkPos.field_9180, class_2806.field_16423, false);
                assert (startChunk != null);
                class_3449 structureStart = startChunk.method_12181(structure);
                assert (structureStart != null);
                class_3341 boundingBox = structureStart.method_14969();
                if (!boundingBox.method_14662((class_2382)block)) continue;
                class_6880 strucutreRegistryEntry = serverWorld.method_30349().method_30530(class_7924.field_41246).method_47983((Object)structure);
                Target target = Target.of(strucutreRegistryEntry, "structure");
                if (target == null) {
                    return -1;
                }
                WikiPage page = WikiPage.fromTarget(target);
                if (page == null) {
                    throw WikiPage.NO_FAMILY_EXCEPTION.create();
                }
                page.openInBrowserCommand(null);
                return 1;
            }
            throw NO_STRUCTURE.create();
        }));
    }
}

