/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.gui.widget;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_5250;
import net.minecraft.class_6379;

public class DropdownWidget<T>
extends class_4265<Entry<T>> {
    private static final class_310 client = class_310.method_1551();
    public static final int ENTRY_HEIGHT = 15;
    protected final List<T> entries;
    protected final Consumer<T> selectCallback;
    private final Runnable onToggle;
    protected T prevSelected;
    protected T selected;
    protected boolean open;
    private final Function<T, class_5250> entryToText;

    public DropdownWidget(class_310 minecraftClient, int x, int y, int width, int maxHeight, List<T> entries, Function<T, class_5250> entryToText, Consumer<T> selectCallback, T selected, Runnable onToggle) {
        super(minecraftClient, width, Math.min((entries.size() + 1) * 15 + 8, maxHeight), y, 15);
        this.onToggle = onToggle;
        this.method_46421(x);
        this.entries = entries;
        this.selectCallback = selectCallback;
        this.selected = selected;
        this.entryToText = entryToText;
        this.method_25315(true, 19);
        for (T entry : entries) {
            this.method_25321((class_350.class_351)new Entry<T>(this, entry, entryToText));
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public int method_25342() {
        return this.method_46426();
    }

    public int method_25322() {
        return this.method_25368();
    }

    public int method_25364() {
        return this.open ? super.method_25364() : 23;
    }

    protected boolean method_25310(int x, int y) {
        this.open = !this.open;
        this.onToggle.run();
        return true;
    }

    protected void method_25312(class_332 context, int x, int y) {
        context.method_27535(DropdownWidget.client.field_1772, (class_2561)this.entryToText.apply(this.selected), x + 4, y + 2, -1);
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 0.0f, 100.0f);
        int y = this.method_46427() - (int)this.method_25341();
        int height = this.method_25317();
        context.method_25294(this.method_46426(), y, this.method_46426() + this.field_22758, y + this.field_22748, -16777216);
        context.method_25292(this.method_46426(), this.method_46426() + this.field_22758, y, -1);
        context.method_25292(this.method_46426(), this.method_46426() + this.field_22758, y + this.field_22748, -1);
        context.method_25301(this.method_46426(), y, y + this.field_22748, -1);
        context.method_25301(this.method_46426() + this.field_22758, y, y + this.field_22748, -1);
        if (this.open) {
            context.method_25294(this.method_46426(), y + this.field_22748 + 1, this.method_46426() + this.field_22758, y + height, -16777216);
            context.method_25292(this.method_46426(), this.method_46426() + this.field_22758, y + height, -1);
            context.method_25301(this.method_46426(), y + this.field_22748, y + height, -1);
            context.method_25301(this.method_46426() + this.field_22758, y + this.field_22748, y + height, -1);
            super.method_48579(context, mouseX, mouseY, delta);
        } else {
            this.method_25312(context, this.method_25342(), y + 4);
        }
        context.method_51448().method_22909();
    }

    protected void method_57715(class_332 context) {
    }

    protected void method_57713(class_332 context) {
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return this.open && super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    protected void select(T entry) {
        this.selected = entry;
        this.open = false;
        this.onToggle.run();
        this.method_25307(0.0);
        if (this.selected != this.prevSelected) {
            this.selectCallback.accept(entry);
            this.prevSelected = this.selected;
        }
    }

    static class Entry<T>
    extends class_4265.class_4266<Entry<T>> {
        private final DropdownWidget<T> dropdownWidget;
        private final T entry;
        private final Function<T, class_5250> entryToText;

        public Entry(DropdownWidget<T> dropdownWidget, T entry, Function<T, class_5250> entryToText) {
            this.dropdownWidget = dropdownWidget;
            this.entry = entry;
            this.entryToText = entryToText;
        }

        public List<? extends class_6379> method_37025() {
            return List.of();
        }

        public List<? extends class_364> method_25396() {
            return List.of();
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            context.method_27535(DropdownWidget.client.field_1772, (class_2561)this.entryToText.apply(this.entry).method_27696(class_2583.field_24360.method_30938(Boolean.valueOf(hovered))), x + 14, y + 2, -1);
            if (this.dropdownWidget.selected == this.entry) {
                context.method_25303(DropdownWidget.client.field_1772, "\u2714", x + 4, y + 2, -1);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0 && this.dropdownWidget.open) {
                this.dropdownWidget.select(this.entry);
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }
    }
}

