/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.minecraft.class_1044;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4280;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.apache.commons.codec.binary.Hex;
import org.jetbrains.annotations.Nullable;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.gui.widget.SuggestionEntryListWidget;
import wiki.minecraft.heywiki.wiki.SearchProvider;

public class SuggestionEntryWidget
extends class_4280.class_4281<SuggestionEntryWidget> {
    public final SearchProvider.Suggestion suggestion;
    protected final class_310 client;
    protected final SuggestionEntryListWidget list;
    private long lastClickTime;

    public SuggestionEntryWidget(SearchProvider.Suggestion suggestion, SuggestionEntryListWidget list) {
        this.suggestion = suggestion;
        this.list = list;
        this.client = class_310.method_1551();
    }

    public class_2561 method_37006() {
        return class_2561.method_43470((String)this.suggestion.title());
    }

    public boolean method_25402(double mouseX, double mouseY, int delta) {
        this.list.select(this);
        long now = System.currentTimeMillis();
        if (now - this.lastClickTime < 250L) {
            this.list.parent.searchEntry(this);
            this.lastClickTime = 0L;
        } else {
            this.lastClickTime = now;
        }
        return true;
    }

    public void method_25343(class_332 DrawContext, int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float delta) {
        class_5250 name;
        int iconSize = 20;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_2960 icon = this.getIconTexture();
        if (icon != null) {
            RenderSystem.enableBlend();
            DrawContext.method_25290(this.getIconTexture(), x + 22, y, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
            RenderSystem.disableBlend();
        }
        if (this.suggestion.title().toLowerCase().contains(this.list.parent.getSearchTerm().toLowerCase())) {
            String title = this.suggestion.title();
            int termIndex = title.toLowerCase().indexOf(this.list.parent.getSearchTerm().toLowerCase());
            name = class_2561.method_43470((String)title.substring(0, termIndex)).method_10852((class_2561)class_2561.method_43470((String)title.substring(termIndex, termIndex + this.list.parent.getSearchTerm().length())).method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(true)))).method_10852(class_2561.method_30163((String)title.substring(termIndex + this.list.parent.getSearchTerm().length())));
        } else {
            name = class_2561.method_43470((String)this.suggestion.title());
        }
        DrawContext.method_35720(this.client.field_1772, class_2477.method_10517().method_30934((class_5348)name), x + 22 + iconSize + 3, y + 1, 0xFFFFFF);
        this.suggestion.redirectsTo().ifPresent(redirect -> {
            class_5250 redirected = class_2561.method_43470((String)redirect);
            DrawContext.method_35720(this.client.field_1772, class_2477.method_10517().method_30934((class_5348)redirected), x + 22 + iconSize + 3, y + 1 + 10, 0xAAAAAA);
        });
    }

    @Nullable
    public class_2960 getIconTexture() {
        return this.suggestion.imageUrl().map(imageUrl -> {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            String hash = Hex.encodeHexString((byte[])md.digest(imageUrl.getBytes(StandardCharsets.UTF_8)));
            class_2960 identifier = HeyWikiClient.id(hash);
            class_1044 texture = this.client.method_1531().method_34590(identifier, null);
            return texture != null ? identifier : null;
        }).orElse(null);
    }
}

