/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.resource;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1078;
import net.minecraft.class_2477;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.mixin.TranslationStorageFactory;
import wiki.minecraft.heywiki.wiki.WikiIndividual;

public class WikiTranslationManager
implements class_4013 {
    private static final HeyWikiClient MOD = HeyWikiClient.getInstance();
    private static final Logger LOGGER = LogUtils.getLogger();
    private Map<String, class_1078> translations;

    @Nullable
    public class_1078 getTranslationOverride(WikiIndividual wiki) {
        return wiki.language().langOverride().map(s -> this.getTranslations().getOrDefault(s, null)).orElse(null);
    }

    public Map<String, class_1078> getTranslations() {
        return this.translations;
    }

    public void method_14491(class_3300 manager) {
        HashMap<String, class_1078> translationsNew = new HashMap<String, class_1078>();
        for (String language : this.decideLanguage()) {
            translationsNew.put(language, WikiTranslationManager.loadTranslation(language, manager, true));
        }
        for (String language : MOD.familyManager().getLangOverride()) {
            translationsNew.put(language, WikiTranslationManager.loadTranslation(language, manager, false));
        }
        this.translations = translationsNew;
    }

    private Set<String> decideLanguage() {
        String configLanguage = MOD.config().language();
        if (configLanguage.equals("auto")) {
            return MOD.familyManager().getAllDefaultLanguages();
        }
        Set<String> mainLanguages = MOD.familyManager().getAllDefaultLanguages();
        Set<String> defaultLanguages = MOD.familyManager().getAllDefaultLanguagesFromWikiLanguage(configLanguage);
        mainLanguages.addAll(defaultLanguages);
        return mainLanguages;
    }

    public static class_1078 loadTranslation(String language, class_3300 resourceManager, boolean fallbackEnUs) {
        return language.equals("en_us") || !fallbackEnUs ? WikiTranslationManager.loadTranslationFrom(resourceManager, List.of(language)) : WikiTranslationManager.loadTranslationFrom(resourceManager, List.of("en_us", language));
    }

    private static class_1078 loadTranslationFrom(class_3300 resourceManager, List<String> definitions) {
        HashMap map = Maps.newHashMap();
        for (String definition : definitions) {
            String path = String.format(Locale.ROOT, "lang/%s.json", definition);
            for (String namespace : resourceManager.method_14487()) {
                try {
                    class_2960 identifier = class_2960.method_60655((String)namespace, (String)path);
                    WikiTranslationManager.appendTranslationFrom(definition, resourceManager.method_14489(identifier), map);
                }
                catch (Exception e) {
                    LOGGER.warn("Skipped language file: {}:{} ({})", new Object[]{namespace, path, e.toString()});
                }
            }
        }
        return TranslationStorageFactory.create((Map<String, String>)ImmutableMap.copyOf((Map)map), false);
    }

    private static void appendTranslationFrom(String langCode, List<class_3298> resourceRefs, Map<String, String> translations) {
        for (class_3298 resource : resourceRefs) {
            try {
                InputStream inputStream = resource.method_14482();
                try {
                    class_2477.method_29425((InputStream)inputStream, translations::put);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                LOGGER.warn("Failed to load translations for {} from pack {}", new Object[]{langCode, resource.method_14480(), e});
            }
        }
    }
}

