/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.target;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1078;
import net.minecraft.class_2477;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.target.Target;
import wiki.minecraft.heywiki.wiki.WikiFamily;
import wiki.minecraft.heywiki.wiki.WikiIndividual;

record IdentifierTarget(class_2960 identifier, Optional<String> translationKey, Optional<String> fallbackTitle) implements Target
{
    private static final class_310 CLIENT = class_310.method_1551();
    private static final HeyWikiClient MOD = HeyWikiClient.getInstance();
    public static final MapCodec<IdentifierTarget> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)class_2960.field_25139.fieldOf("heywiki:identifier").forGetter(target -> target.identifier), (App)Codec.STRING.optionalFieldOf("heywiki:translation_key").forGetter(target -> target.translationKey), (App)Codec.STRING.optionalFieldOf("heywiki:fallback_title").forGetter(target -> target.fallbackTitle)).apply((Applicative)builder, IdentifierTarget::new));

    public IdentifierTarget(class_2960 identifier, String translationKey) {
        this(identifier, Optional.of(translationKey), Optional.empty());
    }

    @Override
    public String namespace() {
        return this.identifier.method_12836();
    }

    @Override
    public String title() {
        WikiFamily family = MOD.familyManager().getFamilyByNamespace(this.identifier.method_12836());
        if (family == null) {
            return null;
        }
        WikiIndividual wiki = Objects.requireNonNull(MOD.familyManager().activeWikis().get(this.identifier.method_12836()));
        class_1078 storage = MOD.translationManager().getTranslationOverride(wiki);
        String fallback = this.fallbackTitle().orElse(this.identifier.method_12832());
        if (this.translationKey().isEmpty()) {
            return fallback;
        }
        String translationKey = this.translationKey().orElseThrow();
        if (storage != null && storage.method_4678(translationKey)) {
            return storage.method_4679(translationKey, fallback);
        }
        if (wiki.language().match(IdentifierTarget.CLIENT.field_1690.field_1883).booleanValue()) {
            return class_2477.method_10517().method_4679(translationKey, fallback);
        }
        return MOD.translationManager().getTranslations().get(wiki.language().defaultLanguage()).method_4679(translationKey, fallback);
    }
}

