/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.wiki;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.gui.screen.ConfirmWikiPageScreen;
import wiki.minecraft.heywiki.target.Target;
import wiki.minecraft.heywiki.util.HttpUtil;
import wiki.minecraft.heywiki.wiki.PageExcerpt;
import wiki.minecraft.heywiki.wiki.WikiIndividual;

public record WikiPage(String pageName, WikiIndividual wiki) {
    public static final class_2561 NO_FAMILY_MESSAGE = class_2561.method_43471((String)"gui.heywiki.no_family").method_10862(class_2583.field_24360.method_10977(class_124.field_1061));
    public static final SimpleCommandExceptionType NO_FAMILY_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"gui.heywiki.no_family"));
    private static final HeyWikiClient MOD = HeyWikiClient.getInstance();

    @Nullable
    public static WikiPage fromTarget(@NotNull Target target) {
        WikiIndividual wiki = MOD.familyManager().activeWikis().get(target.namespace());
        if (wiki == null) {
            return null;
        }
        return new WikiPage(target.title(), wiki);
    }

    @Nullable
    public static WikiPage random(String namespace) {
        WikiIndividual wiki = MOD.familyManager().activeWikis().get(namespace);
        if (wiki == null) {
            return null;
        }
        if (wiki.randomArticle().isEmpty()) {
            return null;
        }
        return new WikiPage(wiki.randomArticle().get(), wiki);
    }

    @Nullable
    public static WikiPage versionArticle(String version) {
        WikiIndividual wiki = MOD.familyManager().activeWikis().get("minecraft");
        if (wiki == null || wiki.versionArticle().isEmpty()) {
            return null;
        }
        Optional<String> name = wiki.versionArticle();
        return name.map(s -> new WikiPage(s.formatted(version), wiki)).orElse(null);
    }

    public void openInBrowserCommand(class_437 parent) {
        this.openInBrowser(MOD.config().requiresConfirmationCommand(), parent);
    }

    public void openInBrowser(class_437 parent) {
        this.openInBrowser(MOD.config().requiresConfirmation(), parent == null ? class_310.method_1551().field_1755 : parent);
    }

    public void openInBrowser(Boolean requiresConfirmation, class_437 parent) {
        URI uri = this.getUri();
        if (requiresConfirmation.booleanValue()) {
            ConfirmWikiPageScreen.open(parent, uri.toString(), PageExcerpt.fromPage(this), this);
        } else {
            class_156.method_668().method_673(uri);
        }
    }

    public URI getUri() {
        try {
            return new URI(this.wiki.articleUrl().formatted(HttpUtil.encodeUrl(this.wiki.title().formatTitle(this.pageName))));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to create URI for wiki page", e);
        }
    }
}

