/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.gui.screen;

import com.mojang.logging.LogUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.SequencedSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_11908;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7842;
import net.minecraft.class_7843;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import net.minecraft.class_8667;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.gui.screen.WikiSelectScreen;
import wiki.minecraft.heywiki.gui.widget.SuggestionEntryListWidget;
import wiki.minecraft.heywiki.gui.widget.SuggestionEntryWidget;
import wiki.minecraft.heywiki.util.CachedDebouncer;
import wiki.minecraft.heywiki.util.HttpUtil;
import wiki.minecraft.heywiki.wiki.SearchProvider;
import wiki.minecraft.heywiki.wiki.WikiFamily;
import wiki.minecraft.heywiki.wiki.WikiIndividual;
import wiki.minecraft.heywiki.wiki.WikiPage;

public class WikiSearchScreen
extends class_437 {
    private static final HeyWikiClient MOD = HeyWikiClient.getInstance();
    private static final Logger LOGGER = LogUtils.getLogger();
    private final CachedDebouncer<String, SequencedSet<SearchProvider.Suggestion>> debouncer = new CachedDebouncer(400L);
    private final List<class_2960> textures = new LinkedList<class_2960>();
    private class_7843 layout = new class_7843(0, 0, this.field_22789, this.field_22790);
    private class_342 textField;
    private SuggestionEntryListWidget entryList;
    private String selectedTitle;
    private String lastSearchTerm;
    private SequencedSet<SearchProvider.Suggestion> suggestions;
    private WikiFamily wikiFamily = MOD.familyManager().getFamily(MOD.config().searchDefaultWikiFamily());
    private WikiIndividual wiki = this.wikiFamily.getWiki();

    public WikiSearchScreen() {
        super((class_2561)class_2561.method_43469((String)"gui.heywiki_search.title", (Object[])new Object[]{class_2561.method_43470((String)"minecraft").method_27696(class_2583.field_24360.method_30938(Boolean.valueOf(true)))}));
    }

    public static void onClientTickPost(class_310 client) {
        if (HeyWikiClient.openWikiSearchKey.method_1436()) {
            client.method_1507((class_437)new WikiSearchScreen());
        }
    }

    public boolean method_25404(class_11908 keyEvent) {
        SuggestionEntryWidget selected = (SuggestionEntryWidget)this.entryList.method_25334();
        String searchTerm = this.textField.method_1882();
        if (keyEvent.comp_4795() == 257) {
            if (searchTerm.isEmpty() || this.method_25399() != this.entryList && this.method_25399() != this.textField) {
                return super.method_25404(keyEvent);
            }
            this.searchEntry(selected);
        }
        return super.method_25404(keyEvent);
    }

    public void searchEntry(SuggestionEntryWidget selected) {
        if (selected != null) {
            if (selected.suggestion.realUrl().isPresent()) {
                class_156.method_668().method_673(URI.create(selected.suggestion.realUrl().get()));
            } else {
                WikiPage page = new WikiPage(selected.suggestion.title(), this.wiki);
                page.openInBrowser(this);
            }
        } else if (this.suggestions != null && !this.suggestions.isEmpty() && this.lastSearchTerm.equalsIgnoreCase(((SearchProvider.Suggestion)this.suggestions.getFirst()).title())) {
            if (((SearchProvider.Suggestion)this.suggestions.getFirst()).realUrl().isPresent()) {
                class_156.method_668().method_673(URI.create(((SearchProvider.Suggestion)this.suggestions.getFirst()).realUrl().get()));
            } else {
                WikiPage page = new WikiPage(((SearchProvider.Suggestion)this.suggestions.getFirst()).title(), this.wiki);
                page.openInBrowser(this);
            }
        } else if (this.wiki.searchUrl().isPresent()) {
            String url = this.wiki.searchUrl().get().formatted(HttpUtil.encodeUrl(this.lastSearchTerm));
            class_156.method_668().method_670(url);
        }
    }

    public void method_25419() {
        assert (this.field_22787 != null);
        this.field_44944.execute(() -> this.textures.forEach(arg_0 -> ((class_1060)this.field_22787.method_1531()).method_4615(arg_0)));
        super.method_25419();
    }

    protected void method_25426() {
        super.method_25426();
        this.layout = new class_7843(0, 0, this.field_22789, this.field_22790);
        this.method_37067();
        class_5250 title = class_2561.method_43469((String)"gui.heywiki_search.title", (Object[])new Object[]{class_2561.method_43471((String)this.wikiFamily.getTranslationKey()).method_27696(class_2583.field_24360.method_30938(Boolean.valueOf(true)))});
        class_7842 titleWidget = new class_7842((class_2561)title, this.field_22793);
        class_8667 mainLayout = (class_8667)this.layout.method_46441((class_8021)class_8667.method_52741().method_52735(10));
        mainLayout.method_52740().method_46467();
        mainLayout.method_52736((class_8021)titleWidget);
        class_8667 omniboxLayout = (class_8667)mainLayout.method_52736((class_8021)class_8667.method_52741().method_52735(4));
        omniboxLayout.method_52740().method_46467();
        class_8667 textFieldLayout = (class_8667)omniboxLayout.method_52736((class_8021)class_8667.method_52742().method_52735(4));
        this.textField = this.textField == null ? new class_342(this.field_22793, 175, 20, (class_2561)title) : this.textField;
        this.textField.method_47404((class_2561)class_2561.method_43471((String)"gui.heywiki_search.placeholder"));
        this.textField.method_1863(this::onSearchChange);
        this.method_48265((class_364)this.textField);
        textFieldLayout.method_52736((class_8021)this.textField);
        textFieldLayout.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.heywiki_search.switch_wiki"), button -> {
            assert (this.field_22787 != null);
            this.field_22787.method_1507((class_437)new WikiSelectScreen(this, MOD.familyManager().getAvailableFamilies().stream().filter(family -> family.getWiki().searchProviderType().isPresent()).sorted().toList(), this.wikiFamily, family -> {
                if (family == this.wikiFamily) {
                    return;
                }
                this.wikiFamily = family;
                this.wiki = family.getWiki();
                this.entryList.clearSuggestions();
                class_5250 changedTitle = class_2561.method_43469((String)"gui.heywiki_search.title", (Object[])new Object[]{class_2561.method_43471((String)this.wikiFamily.getTranslationKey()).method_27696(class_2583.field_24360.method_30938(Boolean.valueOf(true)))});
                titleWidget.method_25355((class_2561)changedTitle);
                this.textField.method_25355((class_2561)changedTitle);
                this.selectedTitle = null;
                String lastTerm = this.getSearchTerm();
                if (lastTerm != null && !lastTerm.isEmpty()) {
                    this.onSearchChange(lastTerm);
                }
            }));
        }).method_46432(71).method_46431());
        this.entryList = new SuggestionEntryListWidget(this.field_22787, 250, 144, 0, this);
        this.wiki.searchProvider().ifPresentOrElse(url -> omniboxLayout.method_52736((class_8021)this.entryList), () -> {
            class_8667 layout = (class_8667)omniboxLayout.method_52736((class_8021)class_8667.method_52741().method_52735(4));
            layout.method_52740().method_46467();
            layout.method_52736((class_8021)new class_7842((class_2561)class_2561.method_43471((String)"gui.heywiki_search.no_suggestions"), this.field_22793));
            layout.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.heywiki_search.search"), button -> {
                if (this.wiki.searchUrl().isPresent()) {
                    String url = this.wiki.searchUrl().orElseThrow().formatted(this.getSearchTerm());
                    class_156.method_668().method_670(url);
                }
            }).method_46432(100).method_46431());
        });
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.method_48640();
    }

    private void onSearchChange(String term) {
        if (term.equals(this.selectedTitle)) {
            return;
        }
        this.lastSearchTerm = term;
        if (term.isEmpty()) {
            this.entryList.clearSuggestions();
            return;
        }
        CompletableFuture.runAsync(() -> this.fetchSuggestions(term).ifPresent(suggestions -> this.field_44944.execute(() -> {
            this.entryList.replaceSuggestions((SequencedSet<SearchProvider.Suggestion>)suggestions);
            this.suggestions = suggestions;
        })), (Executor)class_156.method_27958());
    }

    public String getSearchTerm() {
        return this.lastSearchTerm;
    }

    private Optional<SequencedSet<SearchProvider.Suggestion>> fetchSuggestions(String term) {
        if (term.isEmpty()) {
            return Optional.empty();
        }
        try {
            Optional<SequencedSet<SearchProvider.Suggestion>> suggestions = this.debouncer.get(this.wikiFamily.id().toString() + term, () -> this.wiki.searchProvider().orElseThrow().search(term, this.wiki));
            suggestions.ifPresent(s -> s.forEach(this::fetchImage));
            return suggestions;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to get suggestions", (Throwable)e);
            return Optional.empty();
        }
    }

    private void fetchImage(SearchProvider.Suggestion suggestion) {
        suggestion.imageUrl().ifPresent(imageUrl -> CompletableFuture.runAsync(() -> {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            String hash = Hex.encodeHexString((byte[])md.digest(imageUrl.getBytes(StandardCharsets.UTF_8)));
            class_2960 textureId = HeyWikiClient.id(hash);
            assert (this.field_22787 != null);
            this.field_44944.execute(() -> this.textures.add(textureId));
            byte[] imageArray = HttpUtil.loadAndCacheFile(imageUrl).join();
            this.field_44944.execute(() -> {
                try {
                    BufferedImage image = ImageIO.read(new ByteArrayInputStream(imageArray));
                    if (image == null) {
                        throw new RuntimeException("Failed to load image");
                    }
                    int size = Math.min(image.getWidth(), image.getHeight());
                    image = image.getSubimage((image.getWidth() - size) / 2, (image.getHeight() - size) / 2, size, size);
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)image, "png", os);
                    ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
                    class_1011 nativeImage = class_1011.method_4309((InputStream)is);
                    if (nativeImage == null) {
                        throw new RuntimeException("Texture is null!");
                    }
                    class_1043 texture = new class_1043(() -> ((class_2960)textureId).toString(), nativeImage);
                    this.field_22787.method_1531().method_4616(textureId, (class_1044)texture);
                    this.method_48640();
                }
                catch (IOException e) {
                    LOGGER.error("Failed to load image", (Throwable)e);
                }
            });
        }, (Executor)class_156.method_27958()));
    }

    protected void method_48640() {
        this.layout.method_48222();
        class_7843.method_48634((class_8021)this.layout, (class_8030)this.method_48202());
    }

    public void updateSelectedSuggestion(SearchProvider.Suggestion suggestion) {
        this.selectedTitle = suggestion.title();
        this.textField.method_1852(suggestion.title());
    }
}

