/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.architectury.event.events.client.ClientCommandRegistrationEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import wiki.minecraft.heywiki.target.Target;
import wiki.minecraft.heywiki.wiki.WikiPage;

public class WhatBiomeCommand {
    private static final Minecraft CLIENT = Minecraft.getInstance();

    public static LiteralCommandNode<ClientCommandRegistrationEvent.ClientCommandSourceStack> register(CommandDispatcher<ClientCommandRegistrationEvent.ClientCommandSourceStack> dispatcher) {
        return dispatcher.register((LiteralArgumentBuilder)ClientCommandRegistrationEvent.literal((String)"whatbiome").executes(ctx -> {
            if (WhatBiomeCommand.CLIENT.player == null || WhatBiomeCommand.CLIENT.level == null) {
                return -1;
            }
            BlockPos block = WhatBiomeCommand.CLIENT.player.getOnPos();
            Holder biomeRegistryEntry = WhatBiomeCommand.CLIENT.level.getBiome(block);
            Target target = Target.of(biomeRegistryEntry, "biome");
            if (target == null) {
                return -1;
            }
            WikiPage page = WikiPage.fromTarget(target);
            if (page == null) {
                throw WikiPage.NO_FAMILY_EXCEPTION.create();
            }
            page.openInBrowserCommand(null);
            return 1;
        }));
    }
}

