/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.architectury.event.events.client.ClientCommandRegistrationEvent;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.command.suggestion.NSPageCombinedSuggestionProvider;
import wiki.minecraft.heywiki.wiki.WikiPage;

public class WikiCommand {
    private static final HeyWikiClient MOD = HeyWikiClient.getInstance();

    public static LiteralCommandNode<ClientCommandRegistrationEvent.ClientCommandSourceStack> register(CommandDispatcher<ClientCommandRegistrationEvent.ClientCommandSourceStack> dispatcher) {
        return dispatcher.register((LiteralArgumentBuilder)ClientCommandRegistrationEvent.literal((String)"wiki").then(ClientCommandRegistrationEvent.argument((String)"page", (ArgumentType)StringArgumentType.greedyString()).suggests((SuggestionProvider)new NSPageCombinedSuggestionProvider()).executes(ctx -> {
            String page = StringArgumentType.getString((CommandContext)ctx, (String)"page");
            String[] pageSplit = page.split(":");
            if (pageSplit.length == 1) {
                new WikiPage(page, MOD.familyManager().activeWikis().get("minecraft")).openInBrowserCommand(null);
                return 1;
            }
            String namespace = pageSplit[0];
            if (MOD.familyManager().getFamilyByNamespace(namespace) == null) {
                new WikiPage(page, MOD.familyManager().activeWikis().get("minecraft")).openInBrowserCommand(null);
                return 1;
            }
            new WikiPage(pageSplit[1], MOD.familyManager().activeWikis().get(pageSplit[0])).openInBrowserCommand(null);
            return 1;
        })));
    }
}

