/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.entrypoint;

import java.lang.runtime.SwitchBootstraps;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.mixin.GameRendererMixin;
import wiki.minecraft.heywiki.target.Target;
import wiki.minecraft.heywiki.wiki.WikiPage;

public class Raycast {
    private static final Minecraft CLIENT = Minecraft.getInstance();
    private static final HeyWikiClient MOD = HeyWikiClient.getInstance();

    public static void onClientTickPost(Minecraft client) {
        if (HeyWikiClient.openWikiKey.consumeClick()) {
            Target target;
            if (client.hasAltDown()) {
                assert (client.player != null);
                target = Target.of(client.player.getInventory().getSelectedItem());
            } else {
                target = Raycast.raycastWithMessage();
            }
            if (target != null) {
                WikiPage page = WikiPage.fromTarget(target);
                if (page == null) {
                    client.gui.setOverlayMessage(WikiPage.NO_FAMILY_MESSAGE, false);
                    return;
                }
                page.openInBrowser(null);
            }
        }
    }

    @Nullable
    public static Target raycastWithMessage() {
        Target target = Raycast.raycast();
        if (target == null) {
            Raycast.CLIENT.gui.setOverlayMessage((Component)Component.translatable((String)"gui.heywiki.too_far"), false);
        }
        return target;
    }

    @Nullable
    public static Target raycast() {
        HitResult hit;
        if (Raycast.CLIENT.player == null || Raycast.CLIENT.level == null) {
            return null;
        }
        double maxReach = MOD.config().raycastReach();
        double blockReach = Math.max(Raycast.CLIENT.player.blockInteractionRange(), maxReach);
        double entityReach = Math.max(Raycast.CLIENT.player.entityInteractionRange(), maxReach);
        HitResult hitResult = hit = ((GameRendererMixin)Raycast.CLIENT.gameRenderer).invokePick(CLIENT.getCameraEntity(), blockReach, entityReach, 1.0f);
        Objects.requireNonNull(hitResult);
        HitResult hitResult2 = hitResult;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntityHitResult.class, BlockHitResult.class}, (Object)hitResult2, n)) {
            case 0: {
                EntityHitResult entityHit = (EntityHitResult)hitResult2;
                Entity entity = entityHit.getEntity();
                return Target.of(entity);
            }
            case 1: {
                BlockHitResult blockHit = (BlockHitResult)hitResult2;
                BlockPos blockPos = blockHit.getBlockPos();
                BlockState blockState = Raycast.CLIENT.level.getBlockState(blockPos);
                Block block = blockState.getBlock();
                return Target.of(block);
            }
        }
        return null;
    }

    public static void onDebugTextRight(List<String> texts) {
        Target target = Raycast.raycast();
        if (target == null) {
            texts.add("heywiki: null");
            return;
        }
        WikiPage page = WikiPage.fromTarget(target);
        if (page == null) {
            texts.add("heywiki: null");
            return;
        }
        texts.add("heywiki: " + URLDecoder.decode(page.getUri().toString(), StandardCharsets.UTF_8));
    }
}

