/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.gui.screen;

import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.wiki.WikiFamily;

public class WikiSelectScreen
extends Screen {
    private static final HeyWikiClient MOD = HeyWikiClient.getInstance();
    private final Screen parent;
    private final Iterable<WikiFamily> wikis;
    private final WikiFamily selected;
    private final Consumer<WikiFamily> onSelection;
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    private WikiOptionListWidget optionList;

    public WikiSelectScreen(Screen parent, Iterable<WikiFamily> wikis, WikiFamily selected, Consumer<WikiFamily> onSelection) {
        super((Component)Component.translatable((String)"gui.heywiki_search.switch_wiki"));
        this.parent = parent;
        this.wikis = wikis;
        this.selected = selected;
        this.onSelection = onSelection;
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        if (keyEvent.key() == 257) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyEvent);
    }

    public void onClose() {
        WikiOptionWidget selected = (WikiOptionWidget)this.optionList.getSelected();
        if (selected != null) {
            this.onSelection.accept(selected.wiki);
            MOD.config().setSearchDefaultWikiFamily(selected.wiki.id());
            Util.nonCriticalIoPool().execute(() -> MOD.config().save(false));
        }
        assert (this.minecraft != null);
        this.minecraft.setScreen(this.parent);
    }

    protected void init() {
        this.clearWidgets();
        this.layout.addTitleHeader((Component)Component.translatable((String)"gui.heywiki_search.switch_wiki"), this.font);
        LinearLayout bodyLayout = LinearLayout.vertical().spacing(5);
        this.optionList = (WikiOptionListWidget)bodyLayout.addChild((LayoutElement)new WikiOptionListWidget(this.minecraft, this.width, this.height - 66, 0, 18, this.wikis, this.selected));
        this.layout.addToContents((LayoutElement)bodyLayout);
        this.layout.addToFooter((LayoutElement)Button.builder((Component)Component.translatable((String)"gui.done"), button -> this.onClose()).width(200).build());
        this.layout.arrangeElements();
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
    }

    public static class WikiOptionListWidget
    extends ObjectSelectionList<WikiOptionWidget> {
        public WikiOptionListWidget(Minecraft client, int width, int height, int y, int entryHeight, Iterable<WikiFamily> wikis, WikiFamily selected) {
            super(client, width, height, y, entryHeight);
            for (WikiFamily wiki : wikis) {
                WikiOptionWidget entry = new WikiOptionWidget(wiki);
                this.addEntry((AbstractSelectionList.Entry)entry);
                if (wiki != selected) continue;
                this.setSelected((AbstractSelectionList.Entry)entry);
            }
        }
    }

    public static class WikiOptionWidget
    extends ObjectSelectionList.Entry<WikiOptionWidget> {
        private final WikiFamily wiki;
        private final Minecraft client;

        public WikiOptionWidget(WikiFamily wiki) {
            this.wiki = wiki;
            this.client = Minecraft.getInstance();
        }

        public Component getNarration() {
            return Component.literal((String)("Wiki: " + String.valueOf(this.wiki.id())));
        }

        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean isHovering, float partialTick) {
            guiGraphics.drawString(this.client.font, (Component)Component.translatable((String)this.wiki.getTranslationKey()), this.getContentX() + 14, this.getContentY() + 2, -1);
        }
    }
}

