/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.mixin.integration.rei;

import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.target.Target;
import wiki.minecraft.heywiki.wiki.WikiPage;

@Pseudo
@Mixin(value={EntryWidget.class})
public abstract class ScreenOverlayImplMixin {
    @Inject(method={"keyPressedIgnoreContains"}, at={@At(value="HEAD")}, remap=false)
    public void keyPressedIgnoreContains(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        EntryStack stack;
        KeyEvent keyEvent = new KeyEvent(keyCode, scanCode, modifiers);
        if (REIRuntime.getInstance().isOverlayVisible() && (stack = this.getCurrentEntry()) != null && !stack.isEmpty()) {
            ItemStack itemStack;
            Target target;
            Object object;
            stack = stack.copy();
            if (HeyWikiClient.openWikiKey.matches(keyEvent) && (object = stack.getValue()) instanceof ItemStack && (target = Target.of(itemStack = (ItemStack)object)) != null) {
                WikiPage page = WikiPage.fromTarget(target);
                if (page == null) {
                    Minecraft.getInstance().gui.setOverlayMessage(WikiPage.NO_FAMILY_MESSAGE, false);
                    return;
                }
                page.openInBrowser(null);
            }
        }
    }

    @Shadow(remap=false)
    public abstract EntryStack<?> getCurrentEntry();
}

