/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.platform.Platform;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.DropdownMenuBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.wiki.WikiIndividual;

public class HeyWikiConfig {
    private static final HeyWikiClient MOD = HeyWikiClient.getInstance();
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<HeyWikiConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("requiresConfirmation").orElse((Object)true).forGetter(HeyWikiConfig::requiresConfirmation), (App)Codec.BOOL.fieldOf("requiresConfirmationCommand").orElse((Object)false).forGetter(HeyWikiConfig::requiresConfirmationCommand), (App)Codec.DOUBLE.validate(value -> {
        double min = 0.0;
        double max = 64.0;
        return value.compareTo(min) >= 0 && value.compareTo(max) <= 0 ? DataResult.success((Object)value) : DataResult.error(() -> "Value must be within range [" + min + ";" + max + "]: " + value);
    }).fieldOf("raycastReach").orElse((Object)5.2).forGetter(HeyWikiConfig::raycastReach), (App)Codec.BOOL.fieldOf("raycastAllowFluid").orElse((Object)false).forGetter(HeyWikiConfig::raycastAllowFluid), (App)Codec.STRING.fieldOf("language").orElse((Object)"auto").forGetter(HeyWikiConfig::language), (App)Codec.STRING.fieldOf("zhVariant").orElse((Object)"auto").forGetter(HeyWikiConfig::zhVariant), (App)ResourceLocation.CODEC.fieldOf("searchDefaultWikiFamily").orElse((Object)HeyWikiClient.id("minecraft")).forGetter(HeyWikiConfig::searchDefaultWikiFamily), (App)Codec.BOOL.fieldOf("prefixSearch").orElse((Object)true).forGetter(HeyWikiConfig::prefixSearch)).apply((Applicative)instance, HeyWikiConfig::new));
    private boolean requiresConfirmation;
    private boolean requiresConfirmationCommand;
    private double raycastReach;
    private boolean raycastAllowFluid;
    private String language;
    private String zhVariant;
    private ResourceLocation searchDefaultWikiFamily;
    private boolean prefixSearch;

    public boolean requiresConfirmation() {
        return this.requiresConfirmation;
    }

    public boolean requiresConfirmationCommand() {
        return this.requiresConfirmationCommand;
    }

    public double raycastReach() {
        return this.raycastReach;
    }

    public boolean raycastAllowFluid() {
        return this.raycastAllowFluid;
    }

    public String language() {
        return this.language;
    }

    public String zhVariant() {
        return this.zhVariant;
    }

    public ResourceLocation searchDefaultWikiFamily() {
        return this.searchDefaultWikiFamily;
    }

    public void setSearchDefaultWikiFamily(ResourceLocation searchDefaultWikiFamily) {
        this.searchDefaultWikiFamily = searchDefaultWikiFamily;
    }

    public boolean prefixSearch() {
        return this.prefixSearch;
    }

    private HeyWikiConfig(boolean requiresConfirmation, boolean requiresConfirmationCommand, double raycastReach, boolean raycastAllowFluid, String language, String zhVariant, ResourceLocation searchDefaultWikiFamily, boolean prefixSearch) {
        this.requiresConfirmation = requiresConfirmation;
        this.requiresConfirmationCommand = requiresConfirmationCommand;
        this.raycastReach = raycastReach;
        this.raycastAllowFluid = raycastAllowFluid;
        this.language = language;
        this.zhVariant = zhVariant;
        this.searchDefaultWikiFamily = searchDefaultWikiFamily;
        this.prefixSearch = prefixSearch;
    }

    public Screen createGui(Screen parent) {
        AtomicReference<Boolean> requireReload = new AtomicReference<Boolean>(false);
        ArrayList<String> languages = new ArrayList<String>(MOD.familyManager().getAllAvailableLanguages());
        languages.addFirst("auto");
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((Component)Component.translatable((String)"options.heywiki.title"));
        ConfigCategory general = builder.getOrCreateCategory((Component)Component.translatable((String)"options.heywiki.category.general"));
        ConfigCategory search = builder.getOrCreateCategory((Component)Component.translatable((String)"options.heywiki.category.search"));
        ConfigCategory language = builder.getOrCreateCategory((Component)Component.translatable((String)"options.heywiki.category.language"));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"options.heywiki.requires_confirmation.name"), this.requiresConfirmation()).setDefaultValue(true).setTooltip(new Component[]{Component.translatable((String)"options.heywiki.requires_confirmation.description")}).setSaveConsumer(newValue -> {
            this.requiresConfirmation = newValue;
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"options.heywiki.requires_confirmation_command.name"), this.requiresConfirmationCommand()).setDefaultValue(false).setTooltip(new Component[]{Component.translatable((String)"options.heywiki.requires_confirmation_command.description")}).setSaveConsumer(newValue -> {
            this.requiresConfirmationCommand = newValue;
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startDoubleField((Component)Component.translatable((String)"options.heywiki.raycast_reach.name"), this.raycastReach()).setDefaultValue(5.2).setMin(0.0).setMax(64.0).setTooltip(new Component[]{Component.translatable((String)"options.heywiki.raycast_reach.description")}).setSaveConsumer(newValue -> {
            this.raycastReach = newValue;
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"options.heywiki.raycast_allow_fluid.name"), this.raycastAllowFluid()).setDefaultValue(false).setTooltip(new Component[]{Component.translatable((String)"options.heywiki.raycast_allow_fluid.description")}).setSaveConsumer(newValue -> {
            this.raycastAllowFluid = newValue;
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.fillKeybindingField((Component)Component.translatable((String)"key.heywiki.open"), HeyWikiClient.openWikiKey).setTooltip(new Component[]{Component.translatable((String)"options.heywiki.open_key.description")}).build());
        language.addEntry((AbstractConfigListEntry)entryBuilder.startDropdownMenu((Component)Component.translatable((String)"options.heywiki.language.name"), DropdownMenuBuilder.TopCellElementBuilder.of((Object)this.language, HeyWikiConfig::normalizeLanguageName, HeyWikiConfig::languageDescription), DropdownMenuBuilder.CellCreatorBuilder.of(HeyWikiConfig::languageDescription)).setSelections(languages).setDefaultValue((Object)"auto").setSuggestionMode(false).setTooltip(new Component[]{Component.translatable((String)"options.heywiki.language.description")}).setSaveConsumer(newValue -> {
            if (!newValue.equals(this.language())) {
                requireReload.set(true);
            }
            this.language = newValue;
        }).build());
        language.addEntry((AbstractConfigListEntry)((DropdownMenuBuilder)entryBuilder.startDropdownMenu((Component)Component.translatable((String)"options.heywiki.zh_variant.name"), DropdownMenuBuilder.TopCellElementBuilder.of((Object)this.zhVariant, HeyWikiConfig::normalizeLanguageName, HeyWikiConfig::zhVariantDescription), DropdownMenuBuilder.CellCreatorBuilder.of(HeyWikiConfig::zhVariantDescription)).setDisplayRequirement(() -> {
            for (WikiIndividual wiki : MOD.familyManager().activeWikis().values()) {
                if (!wiki.language().wikiLanguage().startsWith("zh")) continue;
                return true;
            }
            return false;
        })).setSelections(List.of("auto", "zh", "zh-cn", "zh-tw", "zh-hk")).setDefaultValue((Object)"auto").setSuggestionMode(false).setTooltip(new Component[]{Component.translatable((String)"options.heywiki.zh_variant.description")}).setSaveConsumer(newValue -> {
            this.zhVariant = newValue;
        }).build());
        search.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"options.heywiki.prefix_search.name"), this.raycastAllowFluid()).setDefaultValue(true).setTooltip(new Component[]{Component.translatable((String)"options.heywiki.prefix_search.description")}).setSaveConsumer(newValue -> {
            this.prefixSearch = newValue;
        }).build());
        search.addEntry((AbstractConfigListEntry)entryBuilder.fillKeybindingField((Component)Component.translatable((String)"key.heywiki.open_search"), HeyWikiClient.openWikiSearchKey).setTooltip(new Component[]{Component.translatable((String)"options.heywiki.open_key.description")}).build());
        builder.setSavingRunnable(() -> this.save((Boolean)requireReload.get()));
        return builder.build();
    }

    private static String normalizeLanguageName(String name) {
        if (name.equals(I18n.get((String)"options.heywiki.language.auto", (Object[])new Object[0]))) {
            return "auto";
        }
        return name.split(":")[0];
    }

    private static Component languageDescription(String lang) {
        if (lang.equals("auto")) {
            return Component.translatable((String)"options.heywiki.language.auto");
        }
        return Component.literal((String)(lang + ": " + HeyWikiConfig.getLanguageName(lang)));
    }

    private static Component zhVariantDescription(String lang) {
        return switch (lang) {
            case "auto" -> Component.translatable((String)"options.heywiki.language.auto");
            case "zh" -> Component.literal((String)"zh: \u4e0d\u8f6c\u6362");
            case "zh-cn" -> Component.literal((String)"zh-cn: \u5927\u9646\u7b80\u4f53");
            case "zh-tw" -> Component.literal((String)"zh-tw: \u81fa\u7063\u6b63\u9ad4");
            case "zh-hk" -> Component.literal((String)"zh-hk: \u9999\u6e2f\u7e41\u9ad4");
            default -> throw new IllegalStateException("Unexpected value: " + lang);
        };
    }

    private static String getLanguageName(String lang) {
        Map<String, String> languageNames = Map.of("lzh", "\u6587\u8a00");
        if (languageNames.containsKey(lang)) {
            return languageNames.get(lang);
        }
        Locale locale = Locale.of(lang);
        return locale.getDisplayLanguage(locale);
    }

    public void save(Boolean requireReload) {
        if (requireReload.booleanValue()) {
            Minecraft.getInstance().delayTextureReload();
        }
        Path configPath = Platform.getConfigFolder().resolve("heywiki.json");
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
                JsonWriter jsonWriter = new JsonWriter((Writer)writer);
                jsonWriter.setIndent("  ");
                ((DataResult)JsonOps.INSTANCE.withEncoder(CODEC).apply(this)).result().map(JsonElement::toString).ifPresent(s -> {
                    try {
                        writer.write((String)s);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to write config file", e);
                    }
                });
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write config file", e);
        }
    }

    public static HeyWikiConfig load() {
        JsonElement jsonElement;
        Path configPath = Platform.getConfigFolder().resolve("heywiki.json");
        String json = "{}";
        if (Files.exists(configPath, new LinkOption[0])) {
            try {
                json = Files.readString(configPath);
            }
            catch (IOException e) {
                LOGGER.error("Failed to read config file, resetting config", (Throwable)e);
            }
        }
        try {
            jsonElement = JsonParser.parseString((String)json);
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse config file, resetting config", (Throwable)e);
            jsonElement = JsonParser.parseString((String)"{}");
        }
        return (HeyWikiConfig)((Pair)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).result().orElseThrow()).getFirst();
    }
}

