/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.architectury.event.events.client.ClientCommandRegistrationEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import wiki.minecraft.heywiki.target.Target;
import wiki.minecraft.heywiki.wiki.WikiPage;

public class WhatIsThisItemCommand {
    public static final SimpleCommandExceptionType NO_ITEM_HELD = new SimpleCommandExceptionType((Message)Component.translatable((String)"gui.heywiki.no_item_held"));
    private static final Minecraft CLIENT = Minecraft.getInstance();

    public static LiteralCommandNode<ClientCommandRegistrationEvent.ClientCommandSourceStack> register(CommandDispatcher<ClientCommandRegistrationEvent.ClientCommandSourceStack> dispatcher) {
        assert (WhatIsThisItemCommand.CLIENT.player == null);
        return dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandRegistrationEvent.literal((String)"whatisthisitem").executes(ctx -> WhatIsThisItemCommand.openBrowserForStack(WhatIsThisItemCommand.CLIENT.player.getInventory().getSelected()))).then(ClientCommandRegistrationEvent.literal((String)"offhand").executes(ctx -> WhatIsThisItemCommand.openBrowserForStack((ItemStack)WhatIsThisItemCommand.CLIENT.player.getInventory().offhand.getFirst()))));
    }

    private static int openBrowserForStack(ItemStack stack) throws CommandSyntaxException {
        Target target = Target.of(stack);
        if (target == null) {
            throw NO_ITEM_HELD.create();
        }
        WikiPage page = WikiPage.fromTarget(target);
        if (page == null) {
            throw WikiPage.NO_FAMILY_EXCEPTION.create();
        }
        page.openInBrowserCommand(null);
        return 1;
    }
}

