/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.architectury.event.events.client.ClientCommandRegistrationEvent;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import wiki.minecraft.heywiki.target.Target;
import wiki.minecraft.heywiki.wiki.WikiPage;

public class WhatStructureCommand {
    public static final SimpleCommandExceptionType NO_INTEGRATED_SERVER = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.whatstructure.no_integrated_server"));
    public static final SimpleCommandExceptionType NO_STRUCTURE = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.whatstructure.no_structure"));
    private static final Minecraft CLIENT = Minecraft.getInstance();

    public static LiteralCommandNode<ClientCommandRegistrationEvent.ClientCommandSourceStack> register(CommandDispatcher<ClientCommandRegistrationEvent.ClientCommandSourceStack> dispatcher) {
        return dispatcher.register((LiteralArgumentBuilder)ClientCommandRegistrationEvent.literal((String)"whatstructure").executes(ctx -> {
            if (WhatStructureCommand.CLIENT.player == null || WhatStructureCommand.CLIENT.level == null) {
                return -1;
            }
            BlockPos block = WhatStructureCommand.CLIENT.player.blockPosition();
            if (!CLIENT.hasSingleplayerServer()) {
                throw NO_INTEGRATED_SERVER.create();
            }
            IntegratedServer server = CLIENT.getSingleplayerServer();
            UUID playerUuid = WhatStructureCommand.CLIENT.player.getUUID();
            PlayerList playerManager = Objects.requireNonNull(server).getPlayerList();
            ServerPlayer serverPlayer = playerManager.getPlayer(playerUuid);
            ServerLevel serverWorld = Objects.requireNonNull(serverPlayer).serverLevel();
            ChunkPos chunkPos = new ChunkPos(block);
            ChunkAccess chunk = serverWorld.getChunk(chunkPos.x, chunkPos.z, ChunkStatus.STRUCTURE_REFERENCES, false);
            if (chunk == null) {
                return -1;
            }
            Map references = chunk.getAllReferences();
            for (Map.Entry entry : references.entrySet()) {
                Structure structure = (Structure)entry.getKey();
                LongSet positions = (LongSet)entry.getValue();
                ChunkPos startChunkPos = new ChunkPos(positions.toLongArray()[0]);
                ChunkAccess startChunk = serverWorld.getChunk(startChunkPos.x, startChunkPos.z, ChunkStatus.STRUCTURE_STARTS, false);
                assert (startChunk != null);
                StructureStart structureStart = startChunk.getStartForStructure(structure);
                assert (structureStart != null);
                BoundingBox boundingBox = structureStart.getBoundingBox();
                if (!boundingBox.isInside((Vec3i)block)) continue;
                Holder strucutreRegistryEntry = serverWorld.registryAccess().registryOrThrow(Registries.STRUCTURE).wrapAsHolder((Object)structure);
                Target target = Target.of(strucutreRegistryEntry, "structure");
                if (target == null) {
                    return -1;
                }
                WikiPage page = WikiPage.fromTarget(target);
                if (page == null) {
                    throw WikiPage.NO_FAMILY_EXCEPTION.create();
                }
                page.openInBrowserCommand(null);
                return 1;
            }
            throw NO_STRUCTURE.create();
        }));
    }
}

