/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.gui.screen;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.FocusableTextWidget;
import net.minecraft.client.gui.components.ImageWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.gui.screen.CallbackGameMenuScreen;
import wiki.minecraft.heywiki.util.HttpUtil;
import wiki.minecraft.heywiki.wiki.PageExcerpt;
import wiki.minecraft.heywiki.wiki.WikiPage;

public class ConfirmWikiPageScreen
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final TextureManager textureManager = Minecraft.getInstance().getTextureManager();
    protected final BooleanConsumer callback;
    private final String link;
    private final Component message;
    private final WikiPage page;
    private FrameLayout layout;
    private ResourceLocation textureId;
    private volatile PageExcerpt excerpt;
    private volatile boolean hasExcerpt;
    private volatile byte[] image;

    public ConfirmWikiPageScreen(BooleanConsumer callback, String link, Optional<CompletableFuture<PageExcerpt>> excerpt, WikiPage page) {
        this(callback, (Component)Component.translatable((String)"chat.link.confirmTrusted"), (Component)Component.literal((String)URLDecoder.decode(link, StandardCharsets.UTF_8)), link, excerpt, page);
    }

    private ConfirmWikiPageScreen(BooleanConsumer callback, Component title, Component message, String link, Optional<CompletableFuture<PageExcerpt>> excerpt, WikiPage page) {
        super(title);
        this.layout = new FrameLayout(0, 0, this.width, this.height);
        this.textureId = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/misc/unknown_server.png");
        this.hasExcerpt = false;
        this.image = null;
        this.callback = callback;
        this.message = message;
        this.link = link;
        this.page = page;
        if (excerpt.isPresent()) {
            this.hasExcerpt = true;
            this.loadImage(excerpt.get());
        }
    }

    private void loadImage(@NotNull CompletableFuture<PageExcerpt> excerpt) {
        assert (this.minecraft != null);
        excerpt.thenAccept(result -> {
            if (result == null) {
                this.hasExcerpt = false;
                this.minecraft.execute(this::init);
            }
            this.excerpt = result;
            if (this.excerpt.imageUrl() != null) {
                HttpUtil.loadAndCacheFile(this.excerpt.imageUrl()).thenAccept(image -> {
                    this.image = image;
                    this.minecraft.execute(this::init);
                });
            }
            this.minecraft.execute(this::init);
        });
    }

    public static void open(Screen parent, String url, Optional<CompletableFuture<PageExcerpt>> excerpt, WikiPage page) {
        Minecraft client = Minecraft.getInstance();
        client.setScreen((Screen)new ConfirmWikiPageScreen(confirmed -> {
            if (confirmed) {
                Util.getPlatform().openUri(url);
                if (client.level != null) {
                    CallbackGameMenuScreen.openWithParent(parent, true);
                }
            } else {
                client.setScreen(parent);
            }
        }, url, excerpt, page));
    }

    protected synchronized void init() {
        super.init();
        this.layout = new FrameLayout(0, 0, this.width, this.height);
        this.clearWidgets();
        LinearLayout mainLayout = (LinearLayout)this.layout.addChild((LayoutElement)LinearLayout.vertical().spacing(10));
        mainLayout.defaultCellSetting().alignHorizontallyCenter();
        mainLayout.addChild((LayoutElement)new StringWidget(this.title, this.font));
        ((FocusableTextWidget)mainLayout.addChild((LayoutElement)new FocusableTextWidget(this.width, this.message, this.font, false, 3), positioner -> positioner.paddingVertical(3))).setCentered(false);
        if (this.hasExcerpt) {
            LinearLayout excerptLayout = (LinearLayout)mainLayout.addChild((LayoutElement)LinearLayout.horizontal().spacing(8));
            ImageWidget iconWidget = this.createImageWidget();
            int imageWidth = iconWidget.getWidth();
            excerptLayout.addChild((LayoutElement)iconWidget, positioner -> positioner.padding(5));
            LinearLayout excerptTextLayout = (LinearLayout)excerptLayout.addChild((LayoutElement)LinearLayout.vertical().spacing(8));
            MutableComponent excerptTitle = Component.nullToEmpty((String)(this.excerpt != null ? this.excerpt.title() : this.page.pageName())).copy().withStyle(style -> style.withBold(Boolean.valueOf(true)).withUnderlined(Boolean.valueOf(true)));
            excerptTextLayout.addChild((LayoutElement)new StringWidget((Component)excerptTitle, this.font));
            ((FocusableTextWidget)excerptTextLayout.addChild((LayoutElement)new FocusableTextWidget(this.width - 65 - (imageWidth + 13), (Component)(this.excerpt != null ? Component.nullToEmpty((String)this.excerpt.excerpt().replace("\u200b", "")) : Component.translatable((String)"gui.heywiki_confirm_link.loading_excerpt")), this.font, 5), positioner -> positioner.padding(5))).setCentered(false);
        }
        LinearLayout buttonLayout = (LinearLayout)mainLayout.addChild((LayoutElement)LinearLayout.vertical().spacing(8));
        buttonLayout.defaultCellSetting().alignHorizontallyCenter();
        buttonLayout.addChild((LayoutElement)this.createButtonLayout(), positioner -> positioner.paddingBottom(20));
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    private ImageWidget createImageWidget() {
        int height = 100;
        int realWidth = this.excerpt != null ? this.excerpt.imageWidth() : 0;
        int realHeight = this.excerpt != null ? this.excerpt.imageHeight() : 0;
        double aspectRatio = (double)realWidth / (double)realHeight;
        int maxWidth = 200;
        int width = (int)((double)height * aspectRatio);
        int newWidth = -1;
        if (width > 200) {
            width = 200;
            newWidth = realHeight * (200 / height);
        }
        assert (this.minecraft != null);
        if (this.image != null) {
            try {
                BufferedImage image = ImageIO.read(new ByteArrayInputStream(this.image));
                if (newWidth != -1) {
                    int x = (realWidth - newWidth) / 2;
                    image = image.getSubimage(x, 0, newWidth, realHeight);
                }
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)image, "png", os);
                ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
                DynamicTexture texture = new DynamicTexture(NativeImage.read((InputStream)is));
                this.textureId = HeyWikiClient.id(String.valueOf(this.link.hashCode()));
                textureManager.register(this.textureId, (AbstractTexture)texture);
            }
            catch (Exception e) {
                LOGGER.error("Failed to load image", (Throwable)e);
            }
        }
        return ImageWidget.texture((int)width, (int)height, (ResourceLocation)this.textureId, (int)width, (int)height);
    }

    protected LinearLayout createButtonLayout() {
        LinearLayout layout = LinearLayout.horizontal().spacing(8);
        layout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"chat.link.open"), button -> this.callback.accept(true)).width(100).build());
        layout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"chat.copy"), button -> {
            this.copyToClipboard();
            this.callback.accept(false);
        }).width(100).build());
        layout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.callback.accept(false)).width(100).build());
        return layout;
    }

    public void onClose() {
        if (!this.textureId.equals((Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/misc/unknown_server.png"))) {
            textureManager.release(this.textureId);
        }
        super.onClose();
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        FrameLayout.centerInRectangle((LayoutElement)this.layout, (ScreenRectangle)this.getRectangle());
    }

    public Component getNarrationMessage() {
        return CommonComponents.joinForNarration((Component[])new Component[]{super.getNarrationMessage(), this.message});
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 || HeyWikiClient.openWikiKey.matches(keyCode, scanCode)) {
            this.callback.accept(true);
            return true;
        }
        if (keyCode == 67 && ConfirmWikiPageScreen.hasControlDown() && !ConfirmWikiPageScreen.hasShiftDown() && !ConfirmWikiPageScreen.hasAltDown()) {
            this.callback.accept(false);
            this.copyToClipboard();
            return false;
        }
        if (keyCode == 256) {
            this.callback.accept(false);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void copyToClipboard() {
        assert (this.minecraft != null);
        this.minecraft.keyboardHandler.setClipboard(this.link);
    }
}

