/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.gui.screen;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.SequencedSet;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.gui.screen.WikiSelectScreen;
import wiki.minecraft.heywiki.gui.widget.SuggestionEntryListWidget;
import wiki.minecraft.heywiki.gui.widget.SuggestionEntryWidget;
import wiki.minecraft.heywiki.util.CachedDebouncer;
import wiki.minecraft.heywiki.util.HttpUtil;
import wiki.minecraft.heywiki.wiki.SearchProvider;
import wiki.minecraft.heywiki.wiki.WikiFamily;
import wiki.minecraft.heywiki.wiki.WikiIndividual;
import wiki.minecraft.heywiki.wiki.WikiPage;

public class WikiSearchScreen
extends Screen {
    private static final HeyWikiClient MOD = HeyWikiClient.getInstance();
    private static final Logger LOGGER = LogUtils.getLogger();
    private final CachedDebouncer<String, SequencedSet<SearchProvider.Suggestion>> debouncer = new CachedDebouncer(400L);
    private FrameLayout layout = new FrameLayout(0, 0, this.width, this.height);
    private EditBox textField;
    private final List<ResourceLocation> textures = new LinkedList<ResourceLocation>();
    private SuggestionEntryListWidget entryList;
    private String selectedTitle;
    private String lastSearchTerm;
    private SequencedSet<SearchProvider.Suggestion> suggestions;
    private WikiFamily wikiFamily = MOD.familyManager().getFamily(MOD.config().searchDefaultWikiFamily());
    private WikiIndividual wiki = this.wikiFamily.getWiki();

    public WikiSearchScreen() {
        super((Component)Component.translatable((String)"gui.heywiki_search.title", (Object[])new Object[]{Component.literal((String)"minecraft").withStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true)))}));
    }

    protected void init() {
        super.init();
        this.layout = new FrameLayout(0, 0, this.width, this.height);
        this.clearWidgets();
        LinearLayout mainLayout = (LinearLayout)this.layout.addChild((LayoutElement)LinearLayout.vertical().spacing(10));
        mainLayout.defaultCellSetting().alignHorizontallyCenter();
        mainLayout.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"gui.heywiki_search.title", (Object[])new Object[]{Component.translatable((String)this.wikiFamily.getTranslationKey()).withStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true)))}), this.font));
        LinearLayout omniboxLayout = (LinearLayout)mainLayout.addChild((LayoutElement)LinearLayout.vertical().spacing(4));
        omniboxLayout.defaultCellSetting().alignHorizontallyCenter();
        LinearLayout textFieldLayout = (LinearLayout)omniboxLayout.addChild((LayoutElement)LinearLayout.horizontal().spacing(4));
        this.textField = this.textField == null ? new EditBox(this.font, 175, 20, (Component)Component.translatable((String)"gui.heywiki_search.title", (Object[])new Object[]{Component.translatable((String)this.wikiFamily.getTranslationKey()).withStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true)))})) : this.textField;
        this.textField.setHint((Component)Component.translatable((String)"gui.heywiki_search.placeholder"));
        this.textField.setResponder(this::onSearchChange);
        this.setInitialFocus((GuiEventListener)this.textField);
        textFieldLayout.addChild((LayoutElement)this.textField);
        textFieldLayout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"gui.heywiki_search.switch_wiki"), button -> {
            assert (this.minecraft != null);
            this.minecraft.setScreen((Screen)new WikiSelectScreen(this, MOD.familyManager().getAvailableFamilies().stream().filter(family -> family.getWiki().searchProviderType().isPresent()).sorted().toList(), this.wikiFamily, family -> {
                this.wikiFamily = family;
                this.wiki = family.getWiki();
                this.entryList.clearSuggestions();
                this.init();
            }));
        }).width(71).build());
        this.entryList = new SuggestionEntryListWidget(this.minecraft, 250, 144, 0, this);
        this.wiki.searchProvider().ifPresentOrElse(url -> omniboxLayout.addChild((LayoutElement)this.entryList), () -> {
            LinearLayout layout = (LinearLayout)omniboxLayout.addChild((LayoutElement)LinearLayout.vertical().spacing(4));
            layout.defaultCellSetting().alignHorizontallyCenter();
            layout.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"gui.heywiki_search.no_suggestions"), this.font));
            layout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"gui.heywiki_search.search"), button -> {
                if (this.wiki.searchUrl().isPresent()) {
                    String url = this.wiki.searchUrl().orElseThrow().formatted(this.getSearchTerm());
                    Util.getPlatform().openUri(url);
                }
            }).width(100).build());
        });
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
        this.onSearchChange(this.textField.getValue());
    }

    private void onSearchChange(String term) {
        if (term.equals(this.selectedTitle)) {
            return;
        }
        this.lastSearchTerm = term;
        if (term.isEmpty()) {
            this.entryList.clearSuggestions();
            return;
        }
        CompletableFuture.runAsync(() -> this.fetchSuggestions(term).ifPresent(suggestions -> this.screenExecutor.execute(() -> {
            this.entryList.replaceSuggestions((SequencedSet<SearchProvider.Suggestion>)suggestions);
            this.suggestions = suggestions;
        })), Util.nonCriticalIoPool());
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        SuggestionEntryWidget selected = (SuggestionEntryWidget)this.entryList.getSelected();
        String searchTerm = this.textField.getValue();
        if (keyCode == 257) {
            if (searchTerm.isEmpty() || this.getFocused() != this.entryList && this.getFocused() != this.textField) {
                return super.keyPressed(keyCode, scanCode, modifiers);
            }
            this.searchEntry(selected);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void searchEntry(SuggestionEntryWidget selected) {
        if (selected != null) {
            if (selected.suggestion.realUrl().isPresent()) {
                Util.getPlatform().openUri(URI.create(selected.suggestion.realUrl().get()));
            } else {
                WikiPage page = new WikiPage(selected.suggestion.title(), this.wiki);
                page.openInBrowser(this);
            }
        } else if (this.suggestions != null && !this.suggestions.isEmpty() && this.lastSearchTerm.equalsIgnoreCase(((SearchProvider.Suggestion)this.suggestions.getFirst()).title())) {
            if (((SearchProvider.Suggestion)this.suggestions.getFirst()).realUrl().isPresent()) {
                Util.getPlatform().openUri(URI.create(((SearchProvider.Suggestion)this.suggestions.getFirst()).realUrl().get()));
            } else {
                WikiPage page = new WikiPage(((SearchProvider.Suggestion)this.suggestions.getFirst()).title(), this.wiki);
                page.openInBrowser(this);
            }
        } else if (this.wiki.searchUrl().isPresent()) {
            String url = this.wiki.searchUrl().get().formatted(HttpUtil.encodeUrl(this.lastSearchTerm));
            Util.getPlatform().openUri(url);
        }
    }

    public void onClose() {
        assert (this.minecraft != null);
        this.screenExecutor.execute(() -> this.textures.forEach(arg_0 -> ((TextureManager)this.minecraft.getTextureManager()).release(arg_0)));
        super.onClose();
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        FrameLayout.centerInRectangle((LayoutElement)this.layout, (ScreenRectangle)this.getRectangle());
    }

    public void updateSelectedSuggestion(SearchProvider.Suggestion suggestion) {
        this.selectedTitle = suggestion.title();
        this.textField.setValue(suggestion.title());
    }

    public String getSearchTerm() {
        return this.lastSearchTerm;
    }

    private Optional<SequencedSet<SearchProvider.Suggestion>> fetchSuggestions(String term) {
        if (term.isEmpty()) {
            return Optional.empty();
        }
        try {
            Optional<SequencedSet<SearchProvider.Suggestion>> suggestions = this.debouncer.get(this.wikiFamily.id().toString() + term, () -> this.wiki.searchProvider().orElseThrow().search(term, this.wiki));
            suggestions.ifPresent(s -> s.forEach(this::fetchImage));
            return suggestions;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to get suggestions", (Throwable)e);
            return Optional.empty();
        }
    }

    private void fetchImage(SearchProvider.Suggestion suggestion) {
        suggestion.imageUrl().ifPresent(imageUrl -> CompletableFuture.runAsync(() -> {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            String hash = Hex.encodeHexString((byte[])md.digest(imageUrl.getBytes(StandardCharsets.UTF_8)));
            ResourceLocation textureId = HeyWikiClient.id(hash);
            assert (this.minecraft != null);
            if (this.minecraft.getTextureManager().getTexture(textureId, null) != null) {
                return;
            }
            this.screenExecutor.execute(() -> this.textures.add(textureId));
            byte[] imageArray = HttpUtil.loadAndCacheFile(imageUrl).join();
            this.screenExecutor.execute(() -> {
                try {
                    BufferedImage image = ImageIO.read(new ByteArrayInputStream(imageArray));
                    int size = Math.min(image.getWidth(), image.getHeight());
                    image = image.getSubimage((image.getWidth() - size) / 2, (image.getHeight() - size) / 2, size, size);
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)image, "png", os);
                    ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
                    NativeImage nativeImage = NativeImage.read((InputStream)is);
                    if (nativeImage == null) {
                        throw new RuntimeException("Texture is null!");
                    }
                    DynamicTexture texture = new DynamicTexture(nativeImage);
                    this.minecraft.getTextureManager().register(textureId, (AbstractTexture)texture);
                    this.init();
                }
                catch (IOException e) {
                    LOGGER.error("Failed to load image", (Throwable)e);
                }
            });
        }, Util.nonCriticalIoPool()));
    }

    public static void onClientTickPost(Minecraft client) {
        while (HeyWikiClient.openWikiSearchKey.consumeClick()) {
            client.setScreen((Screen)new WikiSearchScreen());
        }
    }
}

