/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.gui.widget;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class DropdownWidget<T>
extends ContainerObjectSelectionList<Entry<T>> {
    private static final Minecraft client = Minecraft.getInstance();
    public static final int ENTRY_HEIGHT = 15;
    protected final List<T> entries;
    protected final Consumer<T> selectCallback;
    private final Runnable onToggle;
    protected T prevSelected;
    protected T selected;
    protected boolean open;
    private final Function<T, MutableComponent> entryToText;

    public DropdownWidget(Minecraft minecraftClient, int x, int y, int width, int maxHeight, List<T> entries, Function<T, MutableComponent> entryToText, Consumer<T> selectCallback, T selected, Runnable onToggle) {
        super(minecraftClient, width, Math.min((entries.size() + 1) * 15 + 8, maxHeight), y, 15);
        this.onToggle = onToggle;
        this.setX(x);
        this.entries = entries;
        this.selectCallback = selectCallback;
        this.selected = selected;
        this.entryToText = entryToText;
        this.setRenderHeader(true, 19);
        for (T entry : entries) {
            this.addEntry((AbstractSelectionList.Entry)new Entry<T>(this, entry, entryToText));
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public int getRowLeft() {
        return this.getX();
    }

    public int getRowWidth() {
        return this.getWidth();
    }

    public int getHeight() {
        return this.open ? super.getHeight() : 23;
    }

    protected boolean clickedHeader(int x, int y) {
        this.open = !this.open;
        this.onToggle.run();
        return true;
    }

    protected void renderHeader(GuiGraphics context, int x, int y) {
        context.drawString(DropdownWidget.client.font, (Component)this.entryToText.apply(this.selected), x + 4, y + 2, -1);
    }

    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        context.pose().pushPose();
        context.pose().translate(0.0f, 0.0f, 100.0f);
        int y = this.getY() - (int)this.getScrollAmount();
        int height = this.getMaxPosition();
        context.fill(this.getX(), y, this.getX() + this.width, y + this.headerHeight, -16777216);
        context.hLine(this.getX(), this.getX() + this.width, y, -1);
        context.hLine(this.getX(), this.getX() + this.width, y + this.headerHeight, -1);
        context.vLine(this.getX(), y, y + this.headerHeight, -1);
        context.vLine(this.getX() + this.width, y, y + this.headerHeight, -1);
        if (this.open) {
            context.fill(this.getX(), y + this.headerHeight + 1, this.getX() + this.width, y + height, -16777216);
            context.hLine(this.getX(), this.getX() + this.width, y + height, -1);
            context.vLine(this.getX(), y + this.headerHeight, y + height, -1);
            context.vLine(this.getX() + this.width, y + this.headerHeight, y + height, -1);
            super.renderWidget(context, mouseX, mouseY, delta);
        } else {
            this.renderHeader(context, this.getRowLeft(), y + 4);
        }
        context.pose().popPose();
    }

    protected void renderListBackground(GuiGraphics context) {
    }

    protected void renderListSeparators(GuiGraphics context) {
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return this.open && super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    protected void select(T entry) {
        this.selected = entry;
        this.open = false;
        this.onToggle.run();
        this.setScrollAmount(0.0);
        if (this.selected != this.prevSelected) {
            this.selectCallback.accept(entry);
            this.prevSelected = this.selected;
        }
    }

    static class Entry<T>
    extends ContainerObjectSelectionList.Entry<Entry<T>> {
        private final DropdownWidget<T> dropdownWidget;
        private final T entry;
        private final Function<T, MutableComponent> entryToText;

        public Entry(DropdownWidget<T> dropdownWidget, T entry, Function<T, MutableComponent> entryToText) {
            this.dropdownWidget = dropdownWidget;
            this.entry = entry;
            this.entryToText = entryToText;
        }

        public List<? extends NarratableEntry> narratables() {
            return List.of();
        }

        public List<? extends GuiEventListener> children() {
            return List.of();
        }

        public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            context.drawString(DropdownWidget.client.font, (Component)this.entryToText.apply(this.entry).withStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(hovered))), x + 14, y + 2, -1);
            if (this.dropdownWidget.selected == this.entry) {
                context.drawString(DropdownWidget.client.font, "\u2714", x + 4, y + 2, -1);
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (button == 0 && this.dropdownWidget.open) {
                this.dropdownWidget.select(this.entry);
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }
    }
}

