/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.gui.widget;

import java.util.SequencedSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import wiki.minecraft.heywiki.gui.screen.WikiSearchScreen;
import wiki.minecraft.heywiki.gui.widget.SuggestionEntryWidget;
import wiki.minecraft.heywiki.wiki.SearchProvider;

public class SuggestionEntryListWidget
extends ObjectSelectionList<SuggestionEntryWidget> {
    public final WikiSearchScreen parent;

    public SuggestionEntryListWidget(Minecraft client, int width, int height, int y, WikiSearchScreen parent) {
        super(client, width, height, y, 24);
        this.parent = parent;
    }

    public void select(SuggestionEntryWidget entry) {
        this.setSelected(entry);
    }

    protected int getScrollbarPosition() {
        return this.getX() + this.width;
    }

    public int getRowWidth() {
        return this.width - 16;
    }

    public int getRowLeft() {
        return this.getX() - 12;
    }

    public boolean isFocused() {
        return this.parent.getFocused() == this;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 265 || keyCode == 264) {
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        return this.getSelected() != null && ((SuggestionEntryWidget)this.getSelected()).keyPressed(keyCode, scanCode, modifiers);
    }

    public void setSelected(SuggestionEntryWidget entry) {
        super.setSelected((AbstractSelectionList.Entry)entry);
        if (entry != null) {
            this.parent.updateSelectedSuggestion(entry.suggestion);
        }
    }

    public void clearSuggestions() {
        this.clearEntries();
    }

    public void replaceSuggestions(SequencedSet<SearchProvider.Suggestion> suggestions) {
        this.replaceEntries(suggestions.stream().map(suggestion -> new SuggestionEntryWidget((SearchProvider.Suggestion)suggestion, this)).toList());
    }
}

