/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.codec.binary.Hex;
import org.jetbrains.annotations.Nullable;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.gui.widget.SuggestionEntryListWidget;
import wiki.minecraft.heywiki.wiki.SearchProvider;

public class SuggestionEntryWidget
extends ObjectSelectionList.Entry<SuggestionEntryWidget> {
    public final SearchProvider.Suggestion suggestion;
    protected final Minecraft client;
    protected final SuggestionEntryListWidget list;
    private long lastClickTime;

    public SuggestionEntryWidget(SearchProvider.Suggestion suggestion, SuggestionEntryListWidget list) {
        this.suggestion = suggestion;
        this.list = list;
        this.client = Minecraft.getInstance();
    }

    public Component getNarration() {
        return Component.literal((String)this.suggestion.title());
    }

    public boolean mouseClicked(double mouseX, double mouseY, int delta) {
        this.list.select(this);
        long now = System.currentTimeMillis();
        if (now - this.lastClickTime < 250L) {
            this.list.parent.searchEntry(this);
            this.lastClickTime = 0L;
        } else {
            this.lastClickTime = now;
        }
        return true;
    }

    public void render(GuiGraphics DrawContext, int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float delta) {
        MutableComponent name;
        int iconSize = 20;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ResourceLocation icon = this.getIconTexture();
        if (icon != null) {
            RenderSystem.enableBlend();
            DrawContext.blit(this.getIconTexture(), x + 22, y, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
            RenderSystem.disableBlend();
        }
        if (this.suggestion.title().toLowerCase().contains(this.list.parent.getSearchTerm().toLowerCase())) {
            String title = this.suggestion.title();
            int termIndex = title.toLowerCase().indexOf(this.list.parent.getSearchTerm().toLowerCase());
            name = Component.literal((String)title.substring(0, termIndex)).append((Component)Component.literal((String)title.substring(termIndex, termIndex + this.list.parent.getSearchTerm().length())).setStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true)))).append(Component.nullToEmpty((String)title.substring(termIndex + this.list.parent.getSearchTerm().length())));
        } else {
            name = Component.literal((String)this.suggestion.title());
        }
        DrawContext.drawString(this.client.font, Language.getInstance().getVisualOrder((FormattedText)name), x + 22 + iconSize + 3, y + 1, 0xFFFFFF);
        this.suggestion.redirectsTo().ifPresent(redirect -> {
            MutableComponent redirected = Component.literal((String)redirect);
            DrawContext.drawString(this.client.font, Language.getInstance().getVisualOrder((FormattedText)redirected), x + 22 + iconSize + 3, y + 1 + 10, 0xAAAAAA);
        });
    }

    @Nullable
    public ResourceLocation getIconTexture() {
        return this.suggestion.imageUrl().map(imageUrl -> {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            String hash = Hex.encodeHexString((byte[])md.digest(imageUrl.getBytes(StandardCharsets.UTF_8)));
            ResourceLocation identifier = HeyWikiClient.id(hash);
            AbstractTexture texture = this.client.getTextureManager().getTexture(identifier, null);
            return texture != null ? identifier : null;
        }).orElse(null);
    }
}

