/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.mixin;

import com.google.common.collect.Ordering;
import dev.architectury.platform.Platform;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.world.effect.MobEffectInstance;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.mixin.HandledScreenMixin;
import wiki.minecraft.heywiki.target.Target;
import wiki.minecraft.heywiki.wiki.WikiPage;

@Mixin(value={EffectRenderingInventoryScreen.class})
public abstract class AbstractInventoryScreenMixin
extends HandledScreenMixin {
    @Unique
    private int heywiki$mouseX;
    @Unique
    private int heywiki$mouseY;

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="HEAD")})
    public void render(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo cir) {
        this.heywiki$mouseX = mouseX;
        this.heywiki$mouseY = mouseY;
    }

    @Override
    public void keyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (HeyWikiClient.openWikiKey.matches(keyCode, scanCode) && !Platform.isModLoaded((String)"emi")) {
            Minecraft client = Minecraft.getInstance();
            assert (client != null);
            int effectX = this.leftPos + this.imageWidth + 2;
            int availableWidth = this.width - effectX;
            assert (client.player != null);
            Collection effectInstances = client.player.getActiveEffects();
            List effectInstancesSorted = Ordering.natural().sortedCopy((Iterable)effectInstances);
            int effectWidth = 33;
            if (availableWidth >= 120) {
                effectWidth = 121;
            }
            int effectHeight = 33;
            if (effectInstances.size() > 5) {
                effectHeight = 132 / (effectInstances.size() - 1);
            }
            if (availableWidth > 32 && this.heywiki$mouseX >= effectX && this.heywiki$mouseX <= effectX + effectWidth) {
                int effectY = this.topPos;
                MobEffectInstance effectFound = null;
                for (MobEffectInstance effect : effectInstancesSorted) {
                    if (this.heywiki$mouseY >= effectY && this.heywiki$mouseY <= effectY + effectHeight) {
                        effectFound = effect;
                    }
                    effectY += effectHeight;
                }
                if (effectFound != null) {
                    Target target = Target.of(effectFound);
                    assert (target != null);
                    WikiPage page = WikiPage.fromTarget(target);
                    if (page == null) {
                        client.gui.setOverlayMessage(WikiPage.NO_FAMILY_MESSAGE, false);
                        return;
                    }
                    page.openInBrowser(Minecraft.getInstance().screen);
                }
            }
            super.keyPressed(keyCode, scanCode, modifiers, cir);
        }
    }
}

