/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.mixin;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.extension.MerchantScreenInterface;
import wiki.minecraft.heywiki.mixin.ScreenMixin;
import wiki.minecraft.heywiki.target.Target;
import wiki.minecraft.heywiki.wiki.WikiPage;

@Mixin(value={AbstractContainerScreen.class})
public class HandledScreenMixin
extends ScreenMixin {
    @Shadow
    @Nullable
    protected Slot hoveredSlot;
    @Shadow
    protected int leftPos;
    @Shadow
    protected int topPos;
    @Shadow
    protected int imageWidth;

    @Inject(method={"keyPressed(III)Z"}, at={@At(value="HEAD")})
    public void keyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (HeyWikiClient.openWikiKey.matches(keyCode, scanCode)) {
            Slot slot = this.hoveredSlot;
            ItemStack stack = null;
            if (slot != null && slot.hasItem()) {
                stack = slot.getItem();
            } else {
                AbstractContainerScreen abstractContainerScreen = (AbstractContainerScreen)this;
                if (abstractContainerScreen instanceof MerchantScreen) {
                    MerchantScreen that = (MerchantScreen)abstractContainerScreen;
                    stack = ((MerchantScreenInterface)that).heywiki$getHoveredStack();
                }
            }
            if (stack == null) {
                return;
            }
            Target target = Target.of(stack);
            if (target != null) {
                WikiPage page = WikiPage.fromTarget(target);
                if (page == null) {
                    Minecraft.getInstance().gui.setOverlayMessage(WikiPage.NO_FAMILY_MESSAGE, false);
                    return;
                }
                page.openInBrowser(Minecraft.getInstance().screen);
            }
        }
    }
}

