/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.mixin;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookPage;
import net.minecraft.client.gui.screens.recipebook.RecipeButton;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.mixin.RecipeBookResultsMixin;
import wiki.minecraft.heywiki.target.Target;
import wiki.minecraft.heywiki.wiki.WikiPage;

@Mixin(value={RecipeBookComponent.class})
public abstract class RecipeBookWidgetMixin {
    @Shadow
    @Final
    private RecipeBookPage recipeBookPage;
    @Shadow
    @Nullable
    private EditBox searchBox;

    @Shadow
    public abstract boolean isVisible();

    @Inject(method={"keyPressed(III)Z"}, at={@At(value="HEAD")})
    public void keyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        RecipeButton button;
        if (this.isVisible() && this.searchBox != null && !this.searchBox.isFocused() && HeyWikiClient.openWikiKey.matches(keyCode, scanCode) && (button = ((RecipeBookResultsMixin)this.recipeBookPage).heywiki$getHoveredResultButton()) != null) {
            RecipeHolder entry = (RecipeHolder)button.getCollection().getRecipes(false).getFirst();
            assert (Minecraft.getInstance().level != null);
            Target target = Target.of(entry.value().getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
            if (target != null) {
                WikiPage page = WikiPage.fromTarget(target);
                if (page == null) {
                    Minecraft.getInstance().gui.setOverlayMessage(WikiPage.NO_FAMILY_MESSAGE, false);
                    return;
                }
                page.openInBrowser(Minecraft.getInstance().screen);
            }
        }
    }
}

