/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.resource;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import wiki.minecraft.heywiki.wiki.WikiFamily;
import wiki.minecraft.heywiki.wiki.WikiIndividual;

public class WikiFamilyManager
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String PATH = "wiki_family";
    private static final Gson GSON = new Gson();
    private final BiMap<ResourceLocation, WikiFamily> WIKI_FAMILY_MAP = HashBiMap.create();
    private Map<String, WikiIndividual> activeWikis = new HashMap<String, WikiIndividual>();

    public WikiFamilyManager() {
        super(GSON, PATH);
    }

    public WikiFamily getFamily(ResourceLocation id) {
        return (WikiFamily)this.WIKI_FAMILY_MAP.get((Object)id);
    }

    public ResourceLocation getFamilyId(WikiFamily family) {
        return (ResourceLocation)this.WIKI_FAMILY_MAP.inverse().get((Object)family);
    }

    @Nullable
    public WikiFamily getFamilyByNamespace(String namespace) {
        for (WikiFamily family : this.WIKI_FAMILY_MAP.values()) {
            if (!family.namespace().contains(namespace)) continue;
            return family;
        }
        return null;
    }

    public Set<String> getAllAvailableLanguages() {
        return this.WIKI_FAMILY_MAP.values().stream().flatMap(family -> family.wikis().stream().map(wiki -> wiki.language().wikiLanguage())).sorted(Comparator.naturalOrder()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<String> getAvailableNamespaces() {
        return this.WIKI_FAMILY_MAP.values().stream().map(WikiFamily::namespace).collect(HashSet::new, Set::addAll, Set::addAll);
    }

    public Set<WikiFamily> getAvailableFamilies() {
        return new HashSet<WikiFamily>(this.WIKI_FAMILY_MAP.values());
    }

    public Set<String> getAllDefaultLanguages() {
        HashSet<String> languages = new HashSet<String>();
        this.WIKI_FAMILY_MAP.forEach((key, value) -> value.wikis().forEach(wiki -> {
            if (wiki.language().main().booleanValue()) {
                languages.add(wiki.language().defaultLanguage());
            }
        }));
        return languages;
    }

    public Set<String> getAllDefaultLanguagesFromWikiLanguage(String wikiLanguage) {
        HashSet<String> languages = new HashSet<String>();
        this.WIKI_FAMILY_MAP.forEach((key, value) -> value.wikis().forEach(wiki -> {
            if (wiki.language().wikiLanguage().equals(wikiLanguage)) {
                languages.add(wiki.language().defaultLanguage());
            }
        }));
        return languages;
    }

    public Set<String> getLangOverride() {
        HashSet<String> languages = new HashSet<String>();
        this.WIKI_FAMILY_MAP.forEach((key, value) -> {
            for (WikiIndividual wiki : value.wikis()) {
                wiki.language().langOverride().ifPresent(languages::add);
            }
        });
        return languages;
    }

    public Map<String, WikiIndividual> activeWikis() {
        return Collections.unmodifiableMap(this.activeWikis);
    }

    protected void apply(Map<ResourceLocation, JsonElement> prepared, ResourceManager manager, ProfilerFiller profiler) {
        this.WIKI_FAMILY_MAP.clear();
        prepared.forEach((key, value) -> {
            try {
                WikiFamily wikiFamily = (WikiFamily)WikiFamily.CODEC.parse((DynamicOps)JsonOps.INSTANCE, value).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseThrow();
                this.WIKI_FAMILY_MAP.put(key, (Object)wikiFamily);
            }
            catch (Exception e) {
                LOGGER.error("Failed to load wiki family config from {}", key, (Object)e);
            }
        });
        this.activeWikis = this.resolveActiveWikis();
        LOGGER.info("Loaded {} wiki families", (Object)this.WIKI_FAMILY_MAP.size());
    }

    public Map<String, WikiIndividual> resolveActiveWikis() {
        HashMap<String, WikiIndividual> activeWikis = new HashMap<String, WikiIndividual>();
        for (Map.Entry entry : this.WIKI_FAMILY_MAP.entrySet()) {
            WikiFamily family = (WikiFamily)entry.getValue();
            WikiIndividual wiki = family.getWiki();
            for (String namespace : family.namespace()) {
                activeWikis.put(namespace, wiki);
            }
        }
        return activeWikis;
    }
}

