/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.resource;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.locale.Language;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.mixin.TranslationStorageFactory;
import wiki.minecraft.heywiki.wiki.WikiIndividual;

public class WikiTranslationManager
implements ResourceManagerReloadListener {
    private static final HeyWikiClient MOD = HeyWikiClient.getInstance();
    private static final Logger LOGGER = LogUtils.getLogger();
    private Map<String, ClientLanguage> translations;

    @Nullable
    public ClientLanguage getTranslationOverride(WikiIndividual wiki) {
        return wiki.language().langOverride().map(s -> this.getTranslations().getOrDefault(s, null)).orElse(null);
    }

    public Map<String, ClientLanguage> getTranslations() {
        return this.translations;
    }

    public void onResourceManagerReload(ResourceManager manager) {
        HashMap<String, ClientLanguage> translationsNew = new HashMap<String, ClientLanguage>();
        for (String language : this.decideLanguage()) {
            translationsNew.put(language, WikiTranslationManager.loadTranslation(language, manager, true));
        }
        for (String language : MOD.familyManager().getLangOverride()) {
            translationsNew.put(language, WikiTranslationManager.loadTranslation(language, manager, false));
        }
        this.translations = translationsNew;
    }

    private Set<String> decideLanguage() {
        String configLanguage = MOD.config().language();
        if (configLanguage.equals("auto")) {
            return MOD.familyManager().getAllDefaultLanguages();
        }
        Set<String> mainLanguages = MOD.familyManager().getAllDefaultLanguages();
        Set<String> defaultLanguages = MOD.familyManager().getAllDefaultLanguagesFromWikiLanguage(configLanguage);
        mainLanguages.addAll(defaultLanguages);
        return mainLanguages;
    }

    public static ClientLanguage loadTranslation(String language, ResourceManager resourceManager, boolean fallbackEnUs) {
        return language.equals("en_us") || !fallbackEnUs ? WikiTranslationManager.loadTranslationFrom(resourceManager, List.of(language)) : WikiTranslationManager.loadTranslationFrom(resourceManager, List.of("en_us", language));
    }

    private static ClientLanguage loadTranslationFrom(ResourceManager resourceManager, List<String> definitions) {
        HashMap map = Maps.newHashMap();
        for (String definition : definitions) {
            String path = String.format(Locale.ROOT, "lang/%s.json", definition);
            for (String namespace : resourceManager.getNamespaces()) {
                try {
                    ResourceLocation identifier = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
                    WikiTranslationManager.appendTranslationFrom(definition, resourceManager.getResourceStack(identifier), map);
                }
                catch (Exception e) {
                    LOGGER.warn("Skipped language file: {}:{} ({})", new Object[]{namespace, path, e.toString()});
                }
            }
        }
        return TranslationStorageFactory.create((Map<String, String>)ImmutableMap.copyOf((Map)map), false);
    }

    private static void appendTranslationFrom(String langCode, List<Resource> resourceRefs, Map<String, String> translations) {
        for (Resource resource : resourceRefs) {
            try {
                InputStream inputStream = resource.open();
                try {
                    Language.loadFromJson((InputStream)inputStream, translations::put);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                LOGGER.warn("Failed to load translations for {} from pack {}", new Object[]{langCode, resource.sourcePackId(), e});
            }
        }
    }
}

