/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.target;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.locale.Language;
import net.minecraft.resources.ResourceLocation;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.target.Target;
import wiki.minecraft.heywiki.wiki.WikiFamily;
import wiki.minecraft.heywiki.wiki.WikiIndividual;

record IdentifierTarget(ResourceLocation identifier, Optional<String> translationKey, Optional<String> fallbackTitle) implements Target
{
    private static final Minecraft CLIENT = Minecraft.getInstance();
    private static final HeyWikiClient MOD = HeyWikiClient.getInstance();
    public static final MapCodec<IdentifierTarget> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("heywiki:identifier").forGetter(target -> target.identifier), (App)Codec.STRING.optionalFieldOf("heywiki:translation_key").forGetter(target -> target.translationKey), (App)Codec.STRING.optionalFieldOf("heywiki:fallback_title").forGetter(target -> target.fallbackTitle)).apply((Applicative)builder, IdentifierTarget::new));

    public IdentifierTarget(ResourceLocation identifier, String translationKey) {
        this(identifier, Optional.of(translationKey), Optional.empty());
    }

    @Override
    public String namespace() {
        return this.identifier.getNamespace();
    }

    @Override
    public String title() {
        WikiFamily family = MOD.familyManager().getFamilyByNamespace(this.identifier.getNamespace());
        if (family == null) {
            return null;
        }
        WikiIndividual wiki = Objects.requireNonNull(MOD.familyManager().activeWikis().get(this.identifier.getNamespace()));
        ClientLanguage storage = MOD.translationManager().getTranslationOverride(wiki);
        String fallback = this.fallbackTitle().orElse(this.identifier.getPath());
        if (this.translationKey().isEmpty()) {
            return fallback;
        }
        String translationKey = this.translationKey().orElseThrow();
        if (storage != null && storage.has(translationKey)) {
            return storage.getOrDefault(translationKey, fallback);
        }
        if (wiki.language().match(IdentifierTarget.CLIENT.options.languageCode).booleanValue()) {
            return Language.getInstance().getOrDefault(translationKey, fallback);
        }
        return MOD.translationManager().getTranslations().get(wiki.language().defaultLanguage()).getOrDefault(translationKey, fallback);
    }
}

