/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.wiki;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import org.slf4j.Logger;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.wiki.SearchProvider;
import wiki.minecraft.heywiki.wiki.TitleFormat;
import wiki.minecraft.heywiki.wiki.WikiLanguage;

public record WikiIndividual(String articleUrl, Optional<String> mwApiUrl, Optional<String> randomArticle, Optional<String> versionArticle, Optional<String> excerpt, Optional<SearchProvider.ProviderType> searchProviderType, Optional<SearchProvider.AlgoliaProvider> algoliaConfig, Optional<String> searchUrl, WikiLanguage language, TitleFormat title) {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<WikiIndividual> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("article_url").forGetter(wiki -> wiki.articleUrl), (App)Codec.STRING.optionalFieldOf("mw_api_url").forGetter(wiki -> wiki.mwApiUrl), (App)Codec.STRING.optionalFieldOf("random_article").forGetter(wiki -> wiki.randomArticle), (App)Codec.STRING.optionalFieldOf("version_article").forGetter(wiki -> wiki.versionArticle), (App)Codec.STRING.optionalFieldOf("excerpt").forGetter(wiki -> wiki.excerpt), (App)SearchProvider.ProviderType.CODEC.optionalFieldOf("search_provider").forGetter(wiki -> wiki.searchProviderType), (App)SearchProvider.AlgoliaProvider.CODEC.optionalFieldOf("algolia").forGetter(wiki -> wiki.algoliaConfig), (App)Codec.STRING.optionalFieldOf("search_url").forGetter(wiki -> wiki.searchUrl), (App)WikiLanguage.CODEC.fieldOf("language").forGetter(wiki -> wiki.language), (App)TitleFormat.CODEC.fieldOf("title").orElse((Object)TitleFormat.DEFAULT).forGetter(wiki -> wiki.title)).apply((Applicative)builder, WikiIndividual::new));

    public Optional<SearchProvider> searchProvider() {
        if (this.searchProviderType.isEmpty() && this.searchUrl.isPresent()) {
            if (this.mwApiUrl().isPresent()) {
                HeyWikiClient.deprecatedWarning(LOGGER, "search_provider should be specified");
                return Optional.of(new SearchProvider.MediaWikiProvider());
            }
            return Optional.empty();
        }
        return this.searchProviderType.flatMap(providerType -> switch (providerType) {
            default -> throw new MatchException(null, null);
            case SearchProvider.ProviderType.MEDIAWIKI -> Optional.of(new SearchProvider.MediaWikiProvider());
            case SearchProvider.ProviderType.ALGOLIA -> {
                if (this.algoliaConfig.isEmpty()) {
                    HeyWikiClient.deprecatedWarning(LOGGER, "algolia should be specified");
                    yield Optional.empty();
                }
                yield this.algoliaConfig;
            }
        });
    }
}

