/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.architectury.event.events.client.ClientChatEvent;
import dev.architectury.event.events.client.ClientCommandRegistrationEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.event.events.client.ClientTooltipEvent;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import org.slf4j.Logger;
import wiki.minecraft.heywiki.HeyWikiConfig;
import wiki.minecraft.heywiki.command.ImFeelingLuckyCommand;
import wiki.minecraft.heywiki.command.WhatBiomeCommand;
import wiki.minecraft.heywiki.command.WhatCommandCommand;
import wiki.minecraft.heywiki.command.WhatIsThisCommand;
import wiki.minecraft.heywiki.command.WhatIsThisItemCommand;
import wiki.minecraft.heywiki.command.WhatStructureCommand;
import wiki.minecraft.heywiki.command.WhatVersionCommand;
import wiki.minecraft.heywiki.command.WikiCommand;
import wiki.minecraft.heywiki.entrypoint.ChatWikiLinks;
import wiki.minecraft.heywiki.entrypoint.HeyWikiDebugEntry;
import wiki.minecraft.heywiki.entrypoint.Raycast;
import wiki.minecraft.heywiki.gui.screen.WikiSearchScreen;
import wiki.minecraft.heywiki.mixin.DebugScreenEntriesMixin;
import wiki.minecraft.heywiki.resource.WikiFamilyManager;
import wiki.minecraft.heywiki.resource.WikiTranslationManager;
import wiki.minecraft.heywiki.target.Target;
import wiki.minecraft.heywiki.wiki.WikiFamily;

public class HeyWikiClient {
    public static final String MOD_ID = "heywiki";
    public static final KeyMapping.Category HEYWIKI_CATEGORY = new KeyMapping.Category(HeyWikiClient.id("heywiki"));
    public static final KeyMapping openWikiKey = new KeyMapping("key.heywiki.open", InputConstants.Type.KEYSYM, 72, HEYWIKI_CATEGORY);
    public static final KeyMapping openWikiSearchKey = new KeyMapping("key.heywiki.open_search", InputConstants.Type.KEYSYM, 66, HEYWIKI_CATEGORY);
    private static final Set<String> experimentsWarned = new HashSet<String>();
    private static final Set<String> deprecationsWarned = new HashSet<String>();
    private static HeyWikiClient INSTANCE;
    private final WikiFamilyManager familyManager;
    private final WikiTranslationManager translationManager;
    private final HeyWikiConfig config;

    public HeyWikiClient() {
        INSTANCE = this;
        this.config = HeyWikiConfig.load();
        KeyMappingRegistry.register((KeyMapping)openWikiKey);
        KeyMappingRegistry.register((KeyMapping)openWikiSearchKey);
        ClientCommandRegistrationEvent.EVENT.register(HeyWikiClient::registerCommands);
        ClientChatEvent.RECEIVED.register(ChatWikiLinks::onClientChatReceived);
        DebugScreenEntriesMixin.invokeRegister(HeyWikiClient.id("url"), new HeyWikiDebugEntry());
        ClientTooltipEvent.ITEM.register((stack, lines, tooltipContex, flag) -> {
            if (!this.config().itemTooltip()) {
                return;
            }
            if (openWikiKey.isUnbound()) {
                return;
            }
            Target target = Target.of(stack);
            if (target == null) {
                return;
            }
            WikiFamily family = this.familyManager().getFamilyByNamespace(target.namespace());
            if (family == null) {
                return;
            }
            lines.add(Component.translatable((String)"gui.heywiki.tooltip", (Object[])new Object[]{openWikiKey.getTranslatedKeyMessage().copy().setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY))}).setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY)));
        });
        ClientTickEvent.CLIENT_POST.register(Raycast::onClientTickPost);
        ClientTickEvent.CLIENT_POST.register(WikiSearchScreen::onClientTickPost);
        this.familyManager = new WikiFamilyManager();
        this.translationManager = new WikiTranslationManager();
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)this.familyManager, (ResourceLocation)HeyWikiClient.id("family"));
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)this.translationManager, (ResourceLocation)HeyWikiClient.id("translation"), List.of(HeyWikiClient.id("family")));
    }

    private static void registerCommands(CommandDispatcher<ClientCommandRegistrationEvent.ClientCommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        ImFeelingLuckyCommand.register(dispatcher);
        WhatBiomeCommand.register(dispatcher);
        LiteralCommandNode<ClientCommandRegistrationEvent.ClientCommandSourceStack> whatCommandCommand = WhatCommandCommand.register(dispatcher);
        WhatIsThisCommand.register(dispatcher);
        WhatIsThisItemCommand.register(dispatcher);
        LiteralCommandNode<ClientCommandRegistrationEvent.ClientCommandSourceStack> wikiCommand = WikiCommand.register(dispatcher);
        LiteralCommandNode<ClientCommandRegistrationEvent.ClientCommandSourceStack> whatVersionCommand = WhatVersionCommand.register(dispatcher);
        if (Minecraft.getInstance().hasSingleplayerServer()) {
            WhatStructureCommand.register(dispatcher);
        }
        dispatcher.register((LiteralArgumentBuilder)ClientCommandRegistrationEvent.literal((String)"whatis").redirect(wikiCommand));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandRegistrationEvent.literal((String)"whatcmd").redirect(whatCommandCommand));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandRegistrationEvent.literal((String)"whatver").redirect(whatVersionCommand));
    }

    public HeyWikiConfig config() {
        return this.config;
    }

    public WikiFamilyManager familyManager() {
        return this.familyManager;
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static HeyWikiClient getInstance() {
        return INSTANCE;
    }

    public static void experimentalWarning(Logger logger, String feature) {
        if (experimentsWarned.add(feature)) {
            logger.warn("{} is an experimental feature. It is subject to breaking changes in future minor or patch releases.", (Object)feature);
        }
    }

    public static void deprecatedWarning(Logger logger, String feature) {
        if (deprecationsWarned.add(feature)) {
            logger.warn("{} is an experimental feature. It is subject to breaking changes in future minor or patch releases.", (Object)feature);
        }
    }

    public WikiTranslationManager translationManager() {
        return this.translationManager;
    }
}

