/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.entrypoint;

import dev.architectury.event.CompoundEventResult;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.wiki.WikiFamily;
import wiki.minecraft.heywiki.wiki.WikiIndividual;
import wiki.minecraft.heywiki.wiki.WikiPage;

public class ChatWikiLinks {
    private static final HeyWikiClient MOD = HeyWikiClient.getInstance();

    public static CompoundEventResult<Component> onClientChatReceived(ChatType.Bound ignoredBound, Component message) {
        MutableComponent text = Component.empty();
        message.visit((style, string) -> {
            Pattern wikiLinkPattern = Pattern.compile("\\[\\[(.*?)\\]\\]");
            Matcher matcher = wikiLinkPattern.matcher(string);
            int lastEnd = 0;
            while (matcher.find()) {
                text.append((Component)Component.literal((String)string.substring(lastEnd, matcher.start() + 2)).setStyle(style));
                String link = matcher.group(1);
                text.append((Component)Component.literal((String)link).setStyle(style.withClickEvent((ClickEvent)new ClickEvent.OpenUrl(ChatWikiLinks.linkToPage(link).getUri())).withUnderlined(Boolean.valueOf(true))));
                lastEnd = matcher.end() - 2;
            }
            text.append((Component)Component.literal((String)string.substring(lastEnd)).setStyle(style));
            return Optional.empty();
        }, Style.EMPTY);
        return CompoundEventResult.interruptTrue((Object)text);
    }

    public static WikiPage linkToPage(String link) {
        String[] split = link.split(":", 3);
        if (split.length == 1) {
            return new WikiPage(link, MOD.familyManager().activeWikis().get("minecraft"));
        }
        WikiIndividual languageWiki = Objects.requireNonNull(MOD.familyManager().getFamilyByNamespace("minecraft")).getLanguageWikiByWikiLanguage(split[0]);
        if (languageWiki != null) {
            return new WikiPage(link.split(":", 2)[1], languageWiki);
        }
        if (MOD.familyManager().getAvailableNamespaces().contains(split[0])) {
            WikiFamily family;
            WikiIndividual languageWiki1;
            if (split.length == 3 && (languageWiki1 = (family = Objects.requireNonNull(MOD.familyManager().getFamilyByNamespace(split[0]))).getLanguageWikiByWikiLanguage(split[1])) != null) {
                return new WikiPage(split[2], languageWiki1);
            }
            return new WikiPage(link.split(":", 2)[1], MOD.familyManager().activeWikis().get(split[0]));
        }
        return new WikiPage(link, MOD.familyManager().activeWikis().get("minecraft"));
    }
}

