/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.gui.widget;

import java.util.SequencedSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.input.KeyEvent;
import wiki.minecraft.heywiki.gui.screen.WikiSearchScreen;
import wiki.minecraft.heywiki.gui.widget.SuggestionEntryWidget;
import wiki.minecraft.heywiki.wiki.SearchProvider;

public class SuggestionEntryListWidget
extends ObjectSelectionList<SuggestionEntryWidget> {
    public final WikiSearchScreen parent;

    public SuggestionEntryListWidget(Minecraft client, int width, int height, int y, WikiSearchScreen parent) {
        super(client, width, height, y, 24);
        this.parent = parent;
    }

    public void select(SuggestionEntryWidget entry) {
        this.setSelected(entry);
    }

    public void setSelected(SuggestionEntryWidget entry) {
        super.setSelected((AbstractSelectionList.Entry)entry);
        if (entry != null) {
            this.parent.updateSelectedSuggestion(entry.suggestion);
        }
    }

    protected int scrollBarX() {
        return this.getX() + this.width;
    }

    public int getRowLeft() {
        return this.getX() + 6;
    }

    public int getRowWidth() {
        return this.width - 12;
    }

    public boolean isFocused() {
        return this.parent.getFocused() == this;
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        if (keyEvent.key() == 265 || keyEvent.key() == 264) {
            return super.keyPressed(keyEvent);
        }
        return this.getSelected() != null && ((SuggestionEntryWidget)this.getSelected()).keyPressed(keyEvent);
    }

    public void clearSuggestions() {
        this.clearEntries();
    }

    public void replaceSuggestions(SequencedSet<SearchProvider.Suggestion> suggestions) {
        this.replaceEntries(suggestions.stream().map(suggestion -> new SuggestionEntryWidget((SearchProvider.Suggestion)suggestion, this)).toList());
    }
}

