/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.gui.widget;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import org.apache.commons.codec.binary.Hex;
import org.jetbrains.annotations.Nullable;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.gui.widget.SuggestionEntryListWidget;
import wiki.minecraft.heywiki.wiki.SearchProvider;

public class SuggestionEntryWidget
extends ObjectSelectionList.Entry<SuggestionEntryWidget> {
    public final SearchProvider.Suggestion suggestion;
    protected final Minecraft client;
    protected final SuggestionEntryListWidget list;

    public SuggestionEntryWidget(SearchProvider.Suggestion suggestion, SuggestionEntryListWidget list) {
        this.suggestion = suggestion;
        this.list = list;
        this.client = Minecraft.getInstance();
    }

    public Component getNarration() {
        return Component.literal((String)this.suggestion.title());
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        this.list.select(this);
        if (doubleClick) {
            this.list.parent.searchEntry(this);
        }
        return true;
    }

    public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean isHovering, float partialTick) {
        MutableComponent name;
        int iconSize = 20;
        ResourceLocation icon = this.getIconTexture();
        if (icon != null) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.getIconTexture(), this.getContentX() + 2, this.getContentY(), 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize, ARGB.white((float)1.0f));
        }
        if (this.suggestion.title().toLowerCase().contains(this.list.parent.getSearchTerm().toLowerCase())) {
            String title = this.suggestion.title();
            int termIndex = title.toLowerCase().indexOf(this.list.parent.getSearchTerm().toLowerCase());
            name = Component.literal((String)title.substring(0, termIndex)).append((Component)Component.literal((String)title.substring(termIndex, termIndex + this.list.parent.getSearchTerm().length())).setStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true)))).append((Component)Component.literal((String)title.substring(termIndex + this.list.parent.getSearchTerm().length())));
        } else {
            name = Component.literal((String)this.suggestion.title());
        }
        guiGraphics.drawString(this.client.font, Language.getInstance().getVisualOrder((FormattedText)name), this.getContentX() + 2 + iconSize + 3, this.getContentY() + 1, -1);
        this.suggestion.redirectsTo().ifPresent(redirect -> {
            MutableComponent redirected = Component.literal((String)redirect);
            guiGraphics.drawString(this.client.font, Language.getInstance().getVisualOrder((FormattedText)redirected), this.getContentX() + 2 + iconSize + 3, this.getContentY() + 1 + 10, -5592406);
        });
    }

    @Nullable
    public ResourceLocation getIconTexture() {
        return this.suggestion.imageUrl().map(imageUrl -> {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            String hash = Hex.encodeHexString((byte[])md.digest(imageUrl.getBytes(StandardCharsets.UTF_8)));
            ResourceLocation identifier = HeyWikiClient.id(hash);
            AbstractTexture texture = this.client.getTextureManager().getTexture(identifier);
            return texture instanceof DynamicTexture ? identifier : null;
        }).orElse(null);
    }
}

