/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.mixin;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookPage;
import net.minecraft.client.gui.screens.recipebook.RecipeButton;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.mixin.RecipeBookPageMixin;
import wiki.minecraft.heywiki.target.Target;
import wiki.minecraft.heywiki.wiki.WikiPage;

@Mixin(value={RecipeBookComponent.class})
public abstract class RecipeBookWidgetMixin {
    @Shadow
    protected Minecraft minecraft;
    @Shadow
    @Final
    private RecipeBookPage recipeBookPage;
    @Shadow
    @Nullable
    private EditBox searchBox;

    @Inject(method={"keyPressed(Lnet/minecraft/client/input/KeyEvent;)Z"}, at={@At(value="HEAD")})
    public void keyPressed(KeyEvent keyEvent, CallbackInfoReturnable<Boolean> cir) {
        RecipeButton button;
        if (this.isVisible() && this.searchBox != null && !this.searchBox.isFocused() && HeyWikiClient.openWikiKey.matches(keyEvent) && (button = ((RecipeBookPageMixin)this.recipeBookPage).heywiki$getHoveredResultButton()) != null) {
            RecipeDisplayEntry entry = (RecipeDisplayEntry)button.getCollection().getRecipes().getFirst();
            assert (this.minecraft.level != null);
            ContextMap contextParameterMap = SlotDisplayContext.fromLevel((Level)this.minecraft.level);
            Target target = Target.of(entry.display().result().resolveForFirstStack(contextParameterMap));
            if (target != null) {
                WikiPage page = WikiPage.fromTarget(target);
                if (page == null) {
                    Minecraft.getInstance().gui.setOverlayMessage(WikiPage.NO_FAMILY_MESSAGE, false);
                    return;
                }
                page.openInBrowser(Minecraft.getInstance().screen);
            }
        }
    }

    @Shadow
    public abstract boolean isVisible();
}

