/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.target;

import com.mojang.logging.LogUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.target.IdentifierTarget;

public interface Target {
    public static Target of(Block block) {
        if (block instanceof AirBlock) {
            return null;
        }
        return new IdentifierTarget(BuiltInRegistries.BLOCK.getKey((Object)block), block.getDescriptionId());
    }

    public static Target of(Entity entity) {
        Entity entity2 = entity;
        Objects.requireNonNull(entity2);
        Entity entity3 = entity2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemEntity.class, ItemFrame.class}, (Object)entity3, n)) {
            case 0: {
                ItemEntity itemEntity = (ItemEntity)entity3;
                ItemStack stack = itemEntity.getItem();
                return Target.of(stack);
            }
            case 1: {
                ItemFrame itemFrameEntity = (ItemFrame)entity3;
                ItemStack stack = itemFrameEntity.getItem();
                if (stack.isEmpty()) {
                    return new IdentifierTarget(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()), entity.getType().getDescriptionId());
                }
                return Target.of(stack);
            }
        }
        return new IdentifierTarget(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()), entity.getType().getDescriptionId());
    }

    @Nullable
    public static Target of(ItemStack stack) {
        IdentifierTarget target;
        if (stack.isEmpty()) {
            return null;
        }
        if (stack.getComponents().get(DataComponents.CREATIVE_SLOT_LOCK) != null) {
            return null;
        }
        @Nullable CustomData customData = (CustomData)stack.getComponents().get(DataComponents.CUSTOM_DATA);
        if (customData != null && (target = (IdentifierTarget)customData.copyTag().read(IdentifierTarget.CODEC).orElse(null)) != null) {
            HeyWikiClient.experimentalWarning(LogUtils.getLogger(), "Custom item based on custom_data or NBT");
            return target;
        }
        return new IdentifierTarget(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()), stack.getItem().getDescriptionId());
    }

    public static Target of(MobEffectInstance effect) {
        Holder effectEntry = effect.getEffect();
        Optional key = effectEntry.unwrapKey();
        if (key.isEmpty()) {
            return null;
        }
        ResourceLocation identifier = ((ResourceKey)key.get()).location();
        return new IdentifierTarget(identifier, effect.getDescriptionId());
    }

    public static Target of(Holder<?> registryEntry, String translationKeyPrefix) {
        Optional key = registryEntry.unwrapKey();
        if (key.isEmpty()) {
            return null;
        }
        ResourceLocation identifier = ((ResourceKey)key.get()).location();
        return new IdentifierTarget(identifier, identifier.toLanguageKey(translationKeyPrefix));
    }

    public String namespace();

    public String title();
}

