/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.wiki;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import net.minecraft.TracingExecutor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import org.slf4j.Logger;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.util.HttpUtil;
import wiki.minecraft.heywiki.wiki.WikiIndividual;
import wiki.minecraft.heywiki.wiki.WikiPage;

public record PageExcerpt(String title, String excerpt, String imageUrl, int imageWidth, int imageHeight) {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Minecraft CLIENT = Minecraft.getInstance();
    private static final HeyWikiClient MOD = HeyWikiClient.getInstance();
    private static final Cache<String, Optional<CompletableFuture<PageExcerpt>>> excerptCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(10L, TimeUnit.MINUTES).build();

    public static Optional<CompletableFuture<PageExcerpt>> fromPage(WikiPage page) {
        WikiIndividual wiki = page.wiki();
        Optional<String> apiUrl = wiki.mwApiUrl();
        Optional<String> excerptType = wiki.excerpt();
        try {
            return (Optional)excerptCache.get((Object)(wiki.articleUrl() + " " + page.pageName()), () -> excerptType.map(s -> switch (s) {
                case "text_extracts" -> {
                    if (apiUrl.isEmpty()) {
                        LOGGER.error("No MediaWiki API provided for TextExtracts");
                        yield null;
                    }
                    yield PageExcerpt.fromTextExtracts((String)apiUrl.get(), page.pageName(), wiki.language().wikiLanguage());
                }
                case "none" -> null;
                default -> {
                    LOGGER.error("Unknown excerpt type: {}", s);
                    yield null;
                }
            }));
        }
        catch (ExecutionException e) {
            LOGGER.error("Failed to get page excerpt", (Throwable)e);
            return Optional.empty();
        }
    }

    private static CompletableFuture<PageExcerpt> fromTextExtracts(String apiUrl, String pageName, String language) {
        URI uri = URI.create(apiUrl + "?action=query&format=json&prop=info%7Cextracts%7Cpageimages%7Crevisions%7Cinfo&formatversion=2&redirects=true&exintro=true&exchars=525&explaintext=true&exsectionformat=plain&piprop=thumbnail&pithumbsize=640&pilicense=any&rvprop=timestamp&inprop=url&uselang=content&titles=" + HttpUtil.encodeUrl(pageName) + (String)(language.equals("zh") ? "&converttitles=true&variant=" + PageExcerpt.resolveZhVariant(MOD.config().zhVariant()) : ""));
        TracingExecutor executor = Util.ioPool();
        return CompletableFuture.supplyAsync(() -> {
            try {
                String body = HttpUtil.request(uri);
                JsonObject page = JsonParser.parseString((String)body).getAsJsonObject().get("query").getAsJsonObject().get("pages").getAsJsonArray().get(0).getAsJsonObject();
                JsonObject thumbnail = page.has("thumbnail") ? page.get("thumbnail").getAsJsonObject() : null;
                return new PageExcerpt(page.get("title").getAsString(), page.get("extract").getAsString(), thumbnail != null ? thumbnail.get("source").getAsString() : null, thumbnail != null ? thumbnail.get("width").getAsInt() : 0, thumbnail != null ? thumbnail.get("height").getAsInt() : 0);
            }
            catch (Exception e) {
                LOGGER.error("Failed to fetch page excerpt", (Throwable)e);
                return null;
            }
        }, (Executor)executor);
    }

    private static String resolveZhVariant(String variant) {
        if (variant.equals("auto")) {
            return switch (PageExcerpt.CLIENT.options.languageCode) {
                case "zh_cn" -> "zh-cn";
                case "zh_tw" -> "zh-tw";
                case "zh_hk" -> "zh-hk";
                default -> "zh";
            };
        }
        return variant;
    }
}

