/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.wiki;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.util.HttpUtil;
import wiki.minecraft.heywiki.wiki.WikiIndividual;

public interface SearchProvider {
    public SequencedSet<Suggestion> search(String var1, WikiIndividual var2) throws IOException, InterruptedException;

    public record AlgoliaProvider(String apiUrl, String indexName, String apiKey, String appId) implements SearchProvider
    {
        public static final Codec<AlgoliaProvider> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("api_url").forGetter(provider -> provider.apiUrl), (App)Codec.STRING.fieldOf("index_name").forGetter(provider -> provider.indexName), (App)Codec.STRING.fieldOf("api_key").forGetter(provider -> provider.apiKey), (App)Codec.STRING.fieldOf("app_id").forGetter(provider -> provider.appId)).apply((Applicative)builder, AlgoliaProvider::new));
        public static final String SUGGESTION_URL = "/1/indexes/%s/query";

        @Override
        public SequencedSet<Suggestion> search(String term, WikiIndividual wiki) throws IOException, InterruptedException {
            URI uri = HttpUtil.uriWithPath(URI.create(this.apiUrl), String.format(SUGGESTION_URL, this.indexName));
            try (HttpClient client = HttpClient.newBuilder().proxy(ProxySelector.getDefault()).followRedirects(HttpClient.Redirect.ALWAYS).build();){
                HttpRequest request = HttpRequest.newBuilder(uri).POST(HttpRequest.BodyPublishers.ofString("{\n  \"query\": \"%s\",\n  \"analytics\": false,\n  \"attributesToHighlight\": [],\n  \"hitsPerPage\": 10\n}\n".formatted(term))).header("User-Agent", "HeyWikiMod (+https://github.com/mc-wiki/minecraft-mod-heywiki)").header("X-Algolia-Api-Key", this.apiKey).header("X-Algolia-Application-Id", this.appId).build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
                if (response.statusCode() != 200) {
                    throw new IOException("HTTP " + response.statusCode() + " " + response.body());
                }
                TreeSet<Suggestion> suggestions = new TreeSet<Suggestion>();
                JsonObject root = JsonParser.parseString((String)response.body()).getAsJsonObject();
                JsonArray hits = root.getAsJsonArray("hits");
                if (hits == null || hits.isEmpty()) {
                    TreeSet<Suggestion> treeSet = suggestions;
                    return treeSet;
                }
                int counter = 0;
                for (JsonElement hit : hits) {
                    JsonObject hitObject = hit.getAsJsonObject();
                    int index = counter++;
                    String url = hitObject.get("url").getAsString();
                    JsonObject hierarchy = hitObject.get("hierarchy").getAsJsonObject();
                    String title = hierarchy.get("lvl1").getAsString();
                    suggestions.add(new Suggestion(title, index, Optional.empty(), Optional.empty(), Optional.of(url)));
                }
                TreeSet<Suggestion> treeSet = suggestions;
                return treeSet;
            }
        }
    }

    public record MediaWikiProvider() implements SearchProvider
    {
        public static final String PREFIX_SEARCH_SUGGESTION_URL = "action=query&format=json&formatversion=2&converttitles=true&redirects=true&prop=info|pageimages&inprop=url&pilicense=any&piprop=thumbnail&generator=prefixsearch&gpssearch=%s";
        public static final String SEARCH_SUGGESTION_URL = "action=query&format=json&formatversion=2&converttitles=true&redirects=true&prop=info|pageimages&inprop=url&pilicense=any&piprop=thumbnail&generator=search&gsrsearch=%s";
        private static final HeyWikiClient MOD = HeyWikiClient.getInstance();

        @Override
        public SequencedSet<Suggestion> search(String term, WikiIndividual wiki) throws IOException, InterruptedException {
            String apiUrl = wiki.mwApiUrl().orElseThrow();
            URI uri = HttpUtil.uriWithQuery(URI.create(apiUrl), (MOD.config().prefixSearch() ? PREFIX_SEARCH_SUGGESTION_URL : SEARCH_SUGGESTION_URL).formatted(term));
            String response = HttpUtil.request(uri);
            TreeSet<Suggestion> suggestions = new TreeSet<Suggestion>();
            JsonObject root = JsonParser.parseString((String)response).getAsJsonObject();
            @Nullable JsonObject query = root.getAsJsonObject("query");
            if (query == null) {
                return suggestions;
            }
            @Nullable JsonArray redirects = query.getAsJsonArray("redirects");
            Map redirectMap = redirects != null ? StreamSupport.stream(redirects.spliterator(), false).map(JsonElement::getAsJsonObject).map(redirect -> {
                int index = redirect.get("index").getAsInt();
                String from = redirect.get("from").getAsString();
                String to = redirect.get("to").getAsString();
                return new Suggestion(from, index, Optional.of(to), Optional.empty(), Optional.empty());
            }).collect(Collectors.toMap(redirect -> redirect.redirectsTo().orElseThrow(), suggestion -> suggestion, (a, b) -> a)) : Collections.emptyMap();
            @Nullable JsonArray pages = query.getAsJsonArray("pages");
            if (pages != null) {
                StreamSupport.stream(pages.spliterator(), false).map(JsonElement::getAsJsonObject).map(page -> {
                    String title = page.get("title").getAsString();
                    int index = page.get("index").getAsInt();
                    String imageUrl = page.has("thumbnail") ? page.getAsJsonObject("thumbnail").get("source").getAsString() : null;
                    String realUrl = page.get("fullurl").getAsString();
                    if (redirectMap.containsKey(title)) {
                        Suggestion redirect = (Suggestion)redirectMap.get(title);
                        return new Suggestion(redirect.title(), index, Optional.of(title), Optional.ofNullable(imageUrl), Optional.of(realUrl));
                    }
                    return new Suggestion(title, index, Optional.empty(), Optional.ofNullable(imageUrl), Optional.of(realUrl));
                }).forEach(suggestions::add);
            }
            return suggestions;
        }
    }

    public record Suggestion(String title, int index, Optional<String> redirectsTo, Optional<String> imageUrl, Optional<String> realUrl) implements Comparable<Suggestion>
    {
        @Override
        public int compareTo(@NotNull Suggestion o) {
            return Integer.compare(this.index, o.index);
        }
    }

    public static enum ProviderType implements StringRepresentable
    {
        MEDIAWIKI("mediawiki"),
        ALGOLIA("algolia");

        public static final Codec<ProviderType> CODEC;
        private final String name;

        private ProviderType(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromValues(ProviderType::values);
        }
    }
}

