/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.wiki;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.StringRepresentable;

public record TitleFormat(Letter letter, Space space) {
    public static final TitleFormat DEFAULT = new TitleFormat(Letter.IGNORE, Space.IGNORE);
    public static final Codec<TitleFormat> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Letter.CODEC.fieldOf("letter").orElse((Object)Letter.IGNORE).forGetter(matcher -> matcher.letter), (App)Space.CODEC.fieldOf("space").orElse((Object)Space.IGNORE).forGetter(matcher -> matcher.space)).apply((Applicative)builder, TitleFormat::new));

    public String formatTitle(String title) {
        String titleLetter = switch (this.letter().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> title.toLowerCase();
            case 1 -> title.toUpperCase();
            case 2 -> title;
        };
        return switch (this.space().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> titleLetter.replace(" ", "_");
            case 1 -> titleLetter.replace(" ", "-");
            case 2 -> titleLetter;
        };
    }

    public static enum Letter implements StringRepresentable
    {
        LOWER("lower"),
        UPPER("upper"),
        IGNORE("ignore");

        public static final Codec<Letter> CODEC;
        private final String name;

        private Letter(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromValues(Letter::values);
        }
    }

    public static enum Space implements StringRepresentable
    {
        UNDERSCORE("underscore"),
        DASH("dash"),
        IGNORE("ignore");

        public static final Codec<Space> CODEC;
        private final String name;

        private Space(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromValues(Space::values);
        }
    }
}

