/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.wiki;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;

public record WikiLanguage(String wikiLanguage, Boolean main, String defaultLanguage, String regex, Optional<String> exclude, Optional<String> langOverride) {
    public static final Codec<WikiLanguage> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("wiki_language").forGetter(matcher -> matcher.wikiLanguage), (App)Codec.BOOL.fieldOf("main").orElse((Object)false).forGetter(matcher -> matcher.main), (App)Codec.STRING.fieldOf("default").forGetter(matcher -> matcher.defaultLanguage), (App)Codec.STRING.fieldOf("regex").forGetter(matcher -> matcher.regex), (App)Codec.STRING.optionalFieldOf("exclude").forGetter(matcher -> matcher.exclude), (App)Codec.STRING.optionalFieldOf("lang_override").forGetter(matcher -> matcher.langOverride)).apply((Applicative)builder, WikiLanguage::new));

    public Boolean match(String language) {
        if (this.exclude.isEmpty()) {
            return language.matches(this.regex);
        }
        return language.matches(this.regex) && !language.matches(String.valueOf(this.exclude));
    }
}

