/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.wiki;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.gui.screen.ConfirmWikiPageScreen;
import wiki.minecraft.heywiki.target.Target;
import wiki.minecraft.heywiki.util.HttpUtil;
import wiki.minecraft.heywiki.wiki.PageExcerpt;
import wiki.minecraft.heywiki.wiki.WikiIndividual;

public record WikiPage(String pageName, WikiIndividual wiki) {
    public static final Component NO_FAMILY_MESSAGE = Component.translatable((String)"gui.heywiki.no_family").setStyle(Style.EMPTY.withColor(ChatFormatting.RED));
    public static final SimpleCommandExceptionType NO_FAMILY_EXCEPTION = new SimpleCommandExceptionType((Message)Component.translatable((String)"gui.heywiki.no_family"));
    private static final HeyWikiClient MOD = HeyWikiClient.getInstance();

    @Nullable
    public static WikiPage fromTarget(@NotNull Target target) {
        WikiIndividual wiki = MOD.familyManager().activeWikis().get(target.namespace());
        if (wiki == null) {
            return null;
        }
        return new WikiPage(target.title(), wiki);
    }

    @Nullable
    public static WikiPage random(String namespace) {
        WikiIndividual wiki = MOD.familyManager().activeWikis().get(namespace);
        if (wiki == null) {
            return null;
        }
        if (wiki.randomArticle().isEmpty()) {
            return null;
        }
        return new WikiPage(wiki.randomArticle().get(), wiki);
    }

    @Nullable
    public static WikiPage versionArticle(String version) {
        WikiIndividual wiki = MOD.familyManager().activeWikis().get("minecraft");
        if (wiki == null || wiki.versionArticle().isEmpty()) {
            return null;
        }
        Optional<String> name = wiki.versionArticle();
        return name.map(s -> new WikiPage(s.formatted(version), wiki)).orElse(null);
    }

    public void openInBrowserCommand(Screen parent) {
        this.openInBrowser(MOD.config().requiresConfirmationCommand(), parent);
    }

    public void openInBrowser(Boolean requiresConfirmation, Screen parent) {
        URI uri = this.getUri();
        if (requiresConfirmation.booleanValue()) {
            ConfirmWikiPageScreen.open(parent, uri.toString(), PageExcerpt.fromPage(this), this);
        } else {
            Util.getPlatform().openUri(uri);
        }
    }

    public URI getUri() {
        try {
            return new URI(this.wiki.articleUrl().formatted(HttpUtil.encodeUrl(this.wiki.title().formatTitle(this.pageName))));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to create URI for wiki page", e);
        }
    }

    public void openInBrowser(Screen parent) {
        this.openInBrowser(MOD.config().requiresConfirmation(), parent == null ? Minecraft.getInstance().screen : parent);
    }
}

