/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.nexus.network.packets;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import xxrexraptorxx.nexus.items.NexusTracker;

public record MessageC2SPacket() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MessageC2SPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nexus", (String)"nexus_coords_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageC2SPacket> STREAM_CODEC = StreamCodec.ofMember(MessageC2SPacket::write, MessageC2SPacket::new);

    public MessageC2SPacket(FriendlyByteBuf buffer) {
        this();
    }

    public void write(FriendlyByteBuf buffer) {
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static void handle(MessageC2SPacket data, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt1$temp;
            ServerLevel level;
            block13: {
                block12: {
                    Level patt0$temp = context.player().level();
                    if (!(patt0$temp instanceof ServerLevel)) break block12;
                    level = (ServerLevel)patt0$temp;
                    patt1$temp = context.player();
                    if (patt1$temp instanceof ServerPlayer) break block13;
                }
                return;
            }
            ServerPlayer player = (ServerPlayer)patt1$temp;
            BlockPos playerPos = player.getOnPos();
            ServerScoreboard scoreboard = level.getServer().getScoreboard();
            if (!level.isClientSide()) {
                if (scoreboard.getObjectiveNames().contains("RED_NEXUS") || scoreboard.getObjectiveNames().contains("BLUE_NEXUS") || scoreboard.getObjectiveNames().contains("GREEN_NEXUS") || scoreboard.getObjectiveNames().contains("YELLOW_NEXUS") || scoreboard.getObjectiveNames().contains("BLACK_NEXUS") || scoreboard.getObjectiveNames().contains("WHITE_NEXUS")) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.nexus.tracking").withStyle(ChatFormatting.GRAY), false);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"message.nexus.tracking_failed").withStyle(ChatFormatting.GRAY), false);
                }
                if (scoreboard.getObjectiveNames().contains("RED_NEXUS")) {
                    player.displayClientMessage((Component)Component.literal((String)"Nexus ").append((Component)Component.literal((String)String.valueOf(NexusTracker.distance(playerPos, scoreboard.getObjective("RED_NEXUS").getFormattedDisplayName().getString())))).append((Component)Component.translatable((String)"message.nexus.tracker_distance")).withStyle(ChatFormatting.RED), false);
                }
                if (scoreboard.getObjectiveNames().contains("BLUE_NEXUS")) {
                    player.displayClientMessage((Component)Component.literal((String)"Nexus ").append((Component)Component.literal((String)String.valueOf(NexusTracker.distance(playerPos, scoreboard.getObjective("BLUE_NEXUS").getFormattedDisplayName().getString())))).append((Component)Component.translatable((String)"message.nexus.tracker_distance")).withStyle(ChatFormatting.BLUE), false);
                }
                if (scoreboard.getObjectiveNames().contains("GREEN_NEXUS")) {
                    player.displayClientMessage((Component)Component.literal((String)"Nexus ").append((Component)Component.literal((String)String.valueOf(NexusTracker.distance(playerPos, scoreboard.getObjective("GREEN_NEXUS").getFormattedDisplayName().getString())))).append((Component)Component.translatable((String)"message.nexus.tracker_distance")).withStyle(ChatFormatting.GREEN), false);
                }
                if (scoreboard.getObjectiveNames().contains("YELLOW_NEXUS")) {
                    player.displayClientMessage((Component)Component.literal((String)"Nexus ").append((Component)Component.literal((String)String.valueOf(NexusTracker.distance(playerPos, scoreboard.getObjective("YELLOW_NEXUS").getFormattedDisplayName().getString())))).append((Component)Component.translatable((String)"message.nexus.tracker_distance")).withStyle(ChatFormatting.YELLOW), false);
                }
                if (scoreboard.getObjectiveNames().contains("BLACK_NEXUS")) {
                    player.displayClientMessage((Component)Component.literal((String)"Nexus ").append((Component)Component.literal((String)String.valueOf(NexusTracker.distance(playerPos, scoreboard.getObjective("BLACK_NEXUS").getFormattedDisplayName().getString())))).append((Component)Component.translatable((String)"message.nexus.tracker_distance")).withStyle(ChatFormatting.DARK_GRAY), false);
                }
                if (scoreboard.getObjectiveNames().contains("WHITE_NEXUS")) {
                    player.displayClientMessage((Component)Component.literal((String)"Nexus ").append((Component)Component.literal((String)String.valueOf(NexusTracker.distance(playerPos, scoreboard.getObjective("WHITE_NEXUS").getFormattedDisplayName().getString())))).append((Component)Component.translatable((String)"message.nexus.tracker_distance")).withStyle(ChatFormatting.WHITE), false);
                }
            }
        });
    }
}

