/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.nexus.world;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import xxrexraptorxx.magmacore.utils.FormattingHelper;
import xxrexraptorxx.nexus.blocks.NexusBlock;
import xxrexraptorxx.nexus.registries.ModBlocks;
import xxrexraptorxx.nexus.registries.ModItems;
import xxrexraptorxx.nexus.utils.Config;

@EventBusSubscriber(modid="nexus")
public class Events {
    @SubscribeEvent
    public static void NexusEffectEvent(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos = event.getPos();
        Level world = event.getLevel();
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        ItemStack stack = event.getItemStack();
        Item item = stack.getItem();
        Player player = event.getEntity();
        if (!world.isClientSide() && BuiltInRegistries.BLOCK.getKey((Object)block).toString().contains("nexus:nexus")) {
            if (item == ModItems.REPAIR_KIT.get()) {
                NexusBlock.nexusLevelChange(true, world, state, pos, stack, player);
            } else if (Config.getNexusEffectWhenRightClicked()) {
                world.playSound((Entity)((Player)null), pos, SoundEvents.ILLUSIONER_MIRROR_MOVE, SoundSource.BLOCKS, 0.5f, world.random.nextFloat() * 0.15f + 0.8f);
                AreaEffectCloud cloud = new AreaEffectCloud(world, (double)pos.getX(), (double)((float)pos.getY() + 0.2f), (double)pos.getZ());
                cloud.addEffect(new MobEffectInstance(MobEffects.RESISTANCE, 500));
                cloud.setDuration(100);
                cloud.setRadius(8.0f);
                cloud.setWaitTime(10);
                cloud.setCustomParticle((ParticleOptions)ParticleTypes.GLOW);
                world.addFreshEntity((Entity)cloud);
            }
        }
    }

    @SubscribeEvent
    public static void NexusHarvestEvent(PlayerInteractEvent.LeftClickBlock event) {
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        Player player = event.getEntity();
        Block block = level.getBlockState(pos).getBlock();
        if (!level.isClientSide() && Config.getNexusUnderAttackMessage() && !player.isCreative() && BuiltInRegistries.BLOCK.getKey((Object)block).toString().contains("nexus:nexus")) {
            String nexusColor = BuiltInRegistries.BLOCK.getKey((Object)block).toString().substring(12);
            level.getServer().getPlayerList().broadcastSystemMessage((Component)FormattingHelper.setMessageComponent((String)"nexus", (String)"nexus_under_attack", (ChatFormatting)ChatFormatting.getByName((String)nexusColor)), true);
        }
    }

    @SubscribeEvent
    public static void BlockPlaceEvent(PlayerInteractEvent.RightClickBlock event) {
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        if (!world.isClientSide() && event.getItemStack().getItem() != Items.AIR && Config.getNexusSafeZone() != 0) {
            for (Block blocks : BuiltInRegistries.BLOCK) {
                if (BuiltInRegistries.ITEM.getKey((Object)event.getItemStack().getItem()) != BuiltInRegistries.BLOCK.getKey((Object)blocks)) continue;
                int posX = pos.getX();
                int posY = pos.getY();
                int posZ = pos.getZ();
                for (int x = -Config.getNexusSafeZone(); x <= Config.getNexusSafeZone(); ++x) {
                    for (int y = -Config.getNexusSafeZone(); y <= Config.getNexusSafeZone(); ++y) {
                        for (int z = -Config.getNexusSafeZone(); z <= Config.getNexusSafeZone(); ++z) {
                            BlockPos block = new BlockPos(posX + x, posY + y, posZ + z);
                            if (!BuiltInRegistries.BLOCK.getKey((Object)world.getBlockState(block).getBlock()).toString().contains("nexus:nexus") || block.getY() >= pos.getY() + 2) continue;
                            world.playSound((Entity)player, pos, SoundEvents.ANVIL_BREAK, SoundSource.BLOCKS, 0.5f, world.random.nextFloat() * 0.15f + 0.0f);
                            Minecraft.getInstance().player.displayClientMessage((Component)FormattingHelper.setMessageComponent((String)"nexus", (String)"blocked_position", (ChatFormatting)ChatFormatting.RED), true);
                            event.setCanceled(true);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void NexusPlaceEvent(PlayerInteractEvent.RightClickBlock event) {
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        Item item = event.getItemStack().getItem();
        if (Config.getNexusTrackingEnabled() && BuiltInRegistries.ITEM.getKey((Object)item).toString().contains("nexus:nexus") && !BuiltInRegistries.ITEM.getKey((Object)item).toString().contains("nexus:nexus_tracker")) {
            String nexusColor = item.toString().substring(12).toUpperCase();
            String scoreboardName = nexusColor + "_NEXUS";
            if (world.getScoreboard().getObjectiveNames().contains(scoreboardName)) {
                world.getScoreboard().removeObjective(world.getScoreboard().getObjective(scoreboardName));
            }
            world.getScoreboard().addObjective(scoreboardName, ObjectiveCriteria.DUMMY, (Component)Component.literal((String)pos.toShortString().replace("[", "").replace("]", "")), ObjectiveCriteria.RenderType.INTEGER, false, null);
        }
    }

    @SubscribeEvent
    public static void addingToolTips(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.getItem();
        List list = event.getToolTip();
        if (stack.is(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nexus", (String)"nexus")))) {
            if (!InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)340)) {
                list.add(FormattingHelper.setMessageComponent((String)"nexus", (String)"nexus.desc", (ChatFormatting)ChatFormatting.GOLD));
                list.add(FormattingHelper.setMessageComponent((String)"nexus", (String)"hold_shift.desc", (ChatFormatting)ChatFormatting.GREEN));
            } else {
                list.add(FormattingHelper.setMessageComponent((String)"nexus", (String)"gamemode_line_1", (ChatFormatting)ChatFormatting.GOLD).withStyle(ChatFormatting.UNDERLINE));
                list.add(FormattingHelper.setMessageComponent((String)"nexus", (String)"gamemode_line_2", (ChatFormatting)ChatFormatting.GRAY));
                list.add(FormattingHelper.setMessageComponent((String)"nexus", (String)"gamemode_line_3", (ChatFormatting)ChatFormatting.GRAY));
                list.add(FormattingHelper.setMessageComponent((String)"nexus", (String)"gamemode_line_4", (ChatFormatting)ChatFormatting.GRAY));
                list.add(FormattingHelper.setMessageComponent((String)"nexus", (String)"gamemode_line_5", (ChatFormatting)ChatFormatting.GRAY));
                list.add(FormattingHelper.setMessageComponent((String)"nexus", (String)"gamemode_line_6", (ChatFormatting)ChatFormatting.GRAY));
            }
        } else if (BuiltInRegistries.BLOCK.getKey((Object)((Block)ModBlocks.SECURTIY_BARRIER.get())).getPath().equals(BuiltInRegistries.ITEM.getKey((Object)item).getPath()) || BuiltInRegistries.BLOCK.getKey((Object)((Block)ModBlocks.SECURTIY_WALL.get())).getPath().equals(BuiltInRegistries.ITEM.getKey((Object)item).getPath())) {
            list.add(FormattingHelper.setMessageComponent((String)"nexus", (String)"unbreakable", (ChatFormatting)ChatFormatting.GRAY));
        }
    }
}

