/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.nexus.blocks;

import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xxrexraptorxx.nexus.main.Nexus;
import xxrexraptorxx.nexus.utils.Config;
import xxrexraptorxx.nexus.utils.NexusColors;

public class NexusBlock
extends Block {
    public static final Integer MAX_DESTRUCTION_LEVEL = 3;
    public static final IntegerProperty DESTRUCTION_LEVEL = IntegerProperty.create((String)"level", (int)0, (int)(MAX_DESTRUCTION_LEVEL + 1));
    public static final EnumProperty<NexusColors> COLOR = EnumProperty.create((String)"color", NexusColors.class);
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    protected static final VoxelShape CUSTOM_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);

    public NexusBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public int getExpDrop(BlockState state, LevelAccessor level, BlockPos pos, @Nullable BlockEntity blockEntity, @Nullable Entity breaker, ItemStack tool) {
        return (Integer)Config.NEXUS_XP_AMOUNT.get();
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        Random random = new Random();
        String nexusColor = BuiltInRegistries.BLOCK.getKey((Object)this).toString().substring(12);
        ItemStack stack = player.getUseItem();
        if (!level.isClientSide()) {
            if (player.isCreative()) {
                NexusBlock.changeNexusBlockstates(level, pos, state, null, true);
                if (level.getScoreboard().getObjectiveNames().contains(nexusColor.toUpperCase() + "_NEXUS")) {
                    level.getScoreboard().removeObjective(level.getScoreboard().getObjective(nexusColor.toUpperCase() + "_NEXUS"));
                }
            } else {
                NexusBlock.nexusLevelChange(false, level, state, pos, stack, player);
                if (state.getValue((Property)DESTRUCTION_LEVEL) == MAX_DESTRUCTION_LEVEL) {
                    NexusBlock.changeNexusBlockstates(level, pos, state, null, true);
                    level.playSound((Entity)((Player)null), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ANVIL_BREAK, SoundSource.BLOCKS, 0.5f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
                    level.playSound((Entity)((Player)null), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ENDER_DRAGON_DEATH, SoundSource.BLOCKS, 0.5f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
                    this.popExperience(level.getServer().getLevel(player.level().dimension()), pos, (Integer)Config.NEXUS_XP_AMOUNT.get());
                    player.awardStat(Stats.BLOCK_MINED.get((Object)state.getBlock()));
                    CommandSourceStack source = new CommandSourceStack(CommandSource.NULL, Vec3.atCenterOf((Vec3i)pos), Vec2.ZERO, (ServerLevel)level, 2, "nexus", (Component)Component.literal((String)"Nexus").withStyle(ChatFormatting.getByName((String)nexusColor)), level.getServer(), (Entity)player);
                    if (player.getTeam() != null && player.getTeam().getColor() != null) {
                        level.getServer().getPlayerList().broadcastSystemMessage((Component)Component.literal((String)(player.getDisplayName().getString() + " ")).withStyle(player.getTeam().getColor()).append((Component)Component.translatable((String)"message.nexus.nexus_destruction").withStyle(ChatFormatting.getByName((String)nexusColor))), true);
                        level.getServer().getPlayerList().broadcastChatMessage(PlayerChatMessage.system((String)Component.literal((String)(player.getDisplayName().getString() + " ")).withStyle(player.getTeam().getColor()).append((Component)Component.translatable((String)"message.nexus.nexus_destruction").withStyle(ChatFormatting.getByName((String)nexusColor))).getString()), source, ChatType.bind((ResourceKey)ChatType.CHAT, (CommandSourceStack)source));
                    } else {
                        level.getServer().getPlayerList().broadcastSystemMessage((Component)Component.literal((String)(player.getDisplayName().getString() + " ")).append((Component)Component.translatable((String)"message.nexus.nexus_destruction").withStyle(ChatFormatting.getByName((String)nexusColor))), true);
                        level.getServer().getPlayerList().broadcastChatMessage(PlayerChatMessage.system((String)Component.literal((String)(player.getDisplayName().getString() + " ")).append((Component)Component.translatable((String)"message.nexus.nexus_destruction").withStyle(ChatFormatting.getByName((String)nexusColor))).getString()), source, ChatType.bind((ResourceKey)ChatType.CHAT, (CommandSourceStack)source));
                    }
                    if (((Boolean)Config.SPECTATOR_MODE_AFTER_LOST_NEXUS.get()).booleanValue()) {
                        try {
                            List players = level.getServer().getPlayerList().getPlayers();
                            for (ServerPlayer serverPlayer : players) {
                                if (serverPlayer.getTeam().getColor() != ChatFormatting.getByName((String)nexusColor)) continue;
                                serverPlayer.setGameMode(GameType.SPECTATOR);
                            }
                        }
                        catch (Exception e) {
                            Nexus.LOGGER.error((Object)e);
                            Nexus.LOGGER.error("To avoid this error, please add all players to a team and assign compatible colors to the teams!");
                        }
                    }
                    if (((List)Config.NEXUS_REWARDS.get()).size() > 0) {
                        for (String item : (List)Config.NEXUS_REWARDS.get()) {
                            try {
                                ItemEntity drop = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)item.substring(item.indexOf(42) + 1, item.indexOf(58)), (String)item.substring(item.indexOf(58) + 1))), Integer.parseInt(item.substring(0, item.indexOf(42)))));
                                level.addFreshEntity((Entity)drop);
                            }
                            catch (Exception e) {
                                Nexus.LOGGER.error("Invalid item entry in the Nexus Mod 'nexus_rewards' config option!");
                            }
                        }
                    }
                    if (level.getScoreboard().getObjectiveNames().contains(nexusColor.toUpperCase() + "_NEXUS")) {
                        level.getScoreboard().removeObjective(level.getScoreboard().getObjective(nexusColor.toUpperCase() + "_NEXUS"));
                    }
                }
            }
        }
        return false;
    }

    public static void nexusLevelChange(Boolean positive, Level level, BlockState state, BlockPos pos, ItemStack stack, Player player) {
        String nexusColor = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).toString().substring(12);
        Random random = new Random();
        if (!positive.booleanValue()) {
            NexusBlock.changeNexusBlockstates(level, pos, state, false, false);
            level.playSound((Entity)((Player)null), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ANVIL_DESTROY, SoundSource.BLOCKS, 0.5f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
            state.getBlock().popExperience(level.getServer().getLevel(player.level().dimension()), pos, ((Integer)Config.NEXUS_XP_STAGE_AMOUNT.get()).intValue());
            player.awardStat(Stats.ITEM_BROKEN.get((Object)state.getBlock().asItem()));
            if (state.getValue((Property)DESTRUCTION_LEVEL) != MAX_DESTRUCTION_LEVEL) {
                CommandSourceStack source = new CommandSourceStack(CommandSource.NULL, Vec3.atCenterOf((Vec3i)pos), Vec2.ZERO, (ServerLevel)level, 2, "nexus", (Component)Component.literal((String)"Nexus").withStyle(ChatFormatting.getByName((String)nexusColor)), level.getServer(), (Entity)player);
                level.getServer().getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)("message.nexus.nexus_level_" + ((Integer)state.getValue((Property)DESTRUCTION_LEVEL) + 1))).withStyle(ChatFormatting.getByName((String)nexusColor)), true);
                level.getServer().getPlayerList().broadcastChatMessage(PlayerChatMessage.system((String)Component.translatable((String)("message.nexus.nexus_level_" + ((Integer)state.getValue((Property)DESTRUCTION_LEVEL) + 1))).withStyle(ChatFormatting.getByName((String)nexusColor)).getString()), source, ChatType.bind((ResourceKey)ChatType.CHAT, (CommandSourceStack)source));
            }
        } else if (!((Boolean)Config.NEXUS_REPAIRING.get()).booleanValue() || (Integer)state.getValue((Property)DESTRUCTION_LEVEL) == 0) {
            player.displayClientMessage((Component)Component.translatable((String)"message.nexus.not_repair").withStyle(ChatFormatting.getByName((String)nexusColor)), true);
        } else {
            NexusBlock.changeNexusBlockstates(level, pos, state, true, false);
            level.playSound((Entity)((Player)null), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.PLAYER_LEVELUP, SoundSource.BLOCKS, 0.5f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
            level.getServer().getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)"message.nexus.nexus_repair").withStyle(ChatFormatting.getByName((String)nexusColor)), true);
            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
            player.getCooldowns().addCooldown(stack, ((Integer)Config.REPAIR_COOLDOWN.get()).intValue());
            stack.shrink(1);
        }
    }

    private static void changeNexusBlockstates(Level level, BlockPos pos, BlockState state, @Nullable Boolean positive, Boolean destroyed) {
        if (destroyed.booleanValue()) {
            if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
                level.setBlock(pos.above(), Blocks.AIR.defaultBlockState(), 11);
            } else {
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
                level.setBlock(pos.below(), Blocks.AIR.defaultBlockState(), 11);
            }
        } else if (positive.booleanValue()) {
            if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
                level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)DESTRUCTION_LEVEL, (Comparable)Integer.valueOf((Integer)state.getValue((Property)DESTRUCTION_LEVEL) - 1))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER), 11);
                level.setBlock(pos.above(), (BlockState)((BlockState)state.setValue((Property)DESTRUCTION_LEVEL, (Comparable)Integer.valueOf((Integer)state.getValue((Property)DESTRUCTION_LEVEL) - 1))).setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 11);
            } else {
                level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)DESTRUCTION_LEVEL, (Comparable)Integer.valueOf((Integer)state.getValue((Property)DESTRUCTION_LEVEL) - 1))).setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 11);
                level.setBlock(pos.below(), (BlockState)((BlockState)state.setValue((Property)DESTRUCTION_LEVEL, (Comparable)Integer.valueOf((Integer)state.getValue((Property)DESTRUCTION_LEVEL) - 1))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER), 11);
            }
        } else if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)DESTRUCTION_LEVEL, (Comparable)Integer.valueOf((Integer)state.getValue((Property)DESTRUCTION_LEVEL) + 1))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER), 11);
            level.setBlock(pos.above(), (BlockState)((BlockState)state.setValue((Property)DESTRUCTION_LEVEL, (Comparable)Integer.valueOf((Integer)state.getValue((Property)DESTRUCTION_LEVEL) + 1))).setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 11);
        } else {
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)DESTRUCTION_LEVEL, (Comparable)Integer.valueOf((Integer)state.getValue((Property)DESTRUCTION_LEVEL) + 1))).setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 11);
            level.setBlock(pos.below(), (BlockState)((BlockState)state.setValue((Property)DESTRUCTION_LEVEL, (Comparable)Integer.valueOf((Integer)state.getValue((Property)DESTRUCTION_LEVEL) + 1))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER), 11);
        }
    }

    private static ChatFormatting getTeamColor(Player player) {
        if (player.getTeam() != null) {
            return player.getTeam().getColor();
        }
        return ChatFormatting.WHITE;
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return CUSTOM_SHAPE;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.nextDouble() < 0.1) {
            level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ILLUSIONER_PREPARE_BLINDNESS, SoundSource.BLOCKS, 0.1f, level.random.nextFloat() * 0.15f + 0.8f, false);
        }
        for (int i = 0; i < 3; ++i) {
            double x0 = (double)pos.getX() + random.nextDouble();
            double x1 = (double)pos.getY() + random.nextDouble() * 0.5 + 1.8;
            double x2 = (double)pos.getZ() + random.nextDouble();
            double d0 = (double)pos.getX() + random.nextDouble();
            double d1 = (double)pos.getY() + random.nextDouble() * 0.5 + 0.5;
            double d2 = (double)pos.getZ() + random.nextDouble();
            if (((Integer)state.getValue((Property)DESTRUCTION_LEVEL)).equals(1)) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
            } else if (((Integer)state.getValue((Property)DESTRUCTION_LEVEL)).equals(2)) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
            } else if (((Integer)state.getValue((Property)DESTRUCTION_LEVEL)).equals(3)) {
                level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
            }
            level.addParticle((ParticleOptions)ParticleTypes.CRIT, x0, x1, x2, 0.0, 0.0, 0.0);
        }
        double d0 = (double)pos.getX() - 4.0 + (double)random.nextInt(8);
        double d1 = (double)pos.getY() + (double)random.nextInt(5);
        double d2 = (double)pos.getZ() - 4.0 + (double)random.nextInt(8);
        level.addParticle((ParticleOptions)ParticleTypes.GLOW, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        if (((Boolean)Config.GLOWING_EFFECT_FROM_NEXUS.get()).booleanValue()) {
            player.addEffect(new MobEffectInstance(MobEffects.GLOWING, 30, 0, false, false, true));
        }
        return super.getDestroyProgress(state, player, level, pos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DESTRUCTION_LEVEL}).add(new Property[]{HALF}).add(new Property[]{COLOR});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)DESTRUCTION_LEVEL, (Comparable)Integer.valueOf(0))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue(COLOR, (Comparable)((Object)NexusColors.valueOf(BuiltInRegistries.BLOCK.getKey((Object)this).toString().substring(12).toUpperCase())));
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack stack) {
        if (!level.isClientSide() && player.isCreative()) {
            NexusBlock.preventCreativeDropFromBottomPart(level, pos, state, player);
        }
        super.playerDestroy(level, player, pos, state, blockEntity, stack);
    }

    protected static void preventCreativeDropFromBottomPart(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)pState.getValue(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = pLevel.getBlockState(blockpos = pPos.below())).is(pState.getBlock()) && blockstate.getValue(HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockstate1 = blockstate.getFluidState().is((Fluid)Fluids.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
            pLevel.setBlock(blockpos, blockstate1, 35);
            pLevel.levelEvent((Entity)pPlayer, 2001, blockpos, Block.getId((BlockState)blockstate));
        }
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.below();
        BlockState blockstate = pLevel.getBlockState(blockpos);
        return pState.getValue(HALF) == DoubleBlockHalf.LOWER ? blockstate.isFaceSturdy((BlockGetter)pLevel, blockpos, Direction.UP) : blockstate.is((Block)this);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        level.setBlock(pos.above(), (BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }
}

