/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.nexus.items;

import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import xxrexraptorxx.magmacore.utils.FormattingHelper;
import xxrexraptorxx.nexus.network.ModPackets;
import xxrexraptorxx.nexus.network.packets.MessageC2SPacket;
import xxrexraptorxx.nexus.utils.Config;

public class NexusTracker
extends Item {
    public NexusTracker(Item.Properties properties) {
        super(properties.rarity(Rarity.UNCOMMON).stacksTo(1).durability(10));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> list, TooltipFlag flag) {
        list.accept((Component)FormattingHelper.setMessageComponent((String)"nexus", (String)"tracker.desc", (ChatFormatting)ChatFormatting.GRAY));
        if (!((Boolean)Config.NEXUS_TRACKING.get()).booleanValue()) {
            list.accept((Component)FormattingHelper.setMessageComponent((String)"nexus", (String)"function_disabled", (ChatFormatting)ChatFormatting.RED));
        }
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        Random random = new Random();
        if (((Boolean)Config.NEXUS_TRACKING.get()).booleanValue()) {
            level.playSound((Entity)((Player)null), player.position().x, player.position().y, player.position().z, SoundEvents.COMPARATOR_CLICK, SoundSource.PLAYERS, 1.0f, 2.0f / (random.nextFloat() * 0.4f + 0.8f));
            if (level.isClientSide()) {
                ModPackets.sendToAllPlayers(new MessageC2SPacket());
            } else {
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
            if (player instanceof Player) {
                player.getCooldowns().addCooldown(player.getUseItem(), ((Integer)Config.TRACKING_COOLDOWN.get()).intValue());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return false;
    }

    public static int distance(BlockPos playerPos, String nexusPos) {
        int x1 = playerPos.getX();
        int y1 = playerPos.getY();
        int z1 = playerPos.getZ();
        String[] coords = nexusPos.replace("[", "").replace("]", "").split(", ");
        int x2 = Integer.parseInt(coords[0]);
        int y2 = Integer.parseInt(coords[1]);
        int z2 = Integer.parseInt(coords[2]);
        return (int)Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0) + Math.pow(z2 - z1, 2.0));
    }
}

