/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.armageddonmod.procedures;

import java.util.Comparator;
import net.mcreator.armageddonmod.entity.FireBallEntity;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FireBallOnEntityTickUpdateProcedure {
    public static void execute(LevelAccessor world, Entity entity) {
        if (entity == null) {
            return;
        }
        if (entity.getPersistentData().getDouble("DespawnTime") >= 60.0) {
            if (!entity.level().isClientSide()) {
                entity.discard();
            }
        } else {
            entity.getPersistentData().putDouble("DespawnTime", entity.getPersistentData().getDouble("DespawnTime") + 1.0);
        }
        world.addParticle((ParticleOptions)ParticleTypes.FLAME, entity.getX(), entity.getY(), entity.getZ(), 0.0, 1.0, 0.0);
        world.addParticle((ParticleOptions)ParticleTypes.SMOKE, entity.getX(), entity.getY(), entity.getZ(), 0.0, 1.0, 0.0);
        entity.setDeltaMovement(new Vec3(entity.getDeltaMovement().x() + entity.getLookAngle().x * 0.1, entity.getLookAngle().y, entity.getDeltaMovement().z() + entity.getLookAngle().z * 0.1));
        Vec3 _center = new Vec3(entity.getX(), entity.getY(), entity.getZ());
        for (Entity entityiterator : world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(0.5), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList()) {
            if (entityiterator instanceof FireBallEntity || entityiterator instanceof Player || !(entityiterator instanceof LivingEntity)) continue;
            entityiterator.hurt(new DamageSource(world.holderOrThrow(DamageTypes.GENERIC)), 20.0f);
            entityiterator.igniteForSeconds(10.0f);
            if (entity.level().isClientSide()) continue;
            entity.discard();
        }
    }
}

