/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.armageddonmod.procedures;

import java.util.Comparator;
import net.mcreator.armageddonmod.entity.RiftEntity;
import net.mcreator.armageddonmod.entity.StarBulletEntity;
import net.mcreator.armageddonmod.init.ArmageddonModModMobEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class StarBulletOnEntityTickUpdateProcedure {
    public static void execute(LevelAccessor world, Entity entity) {
        if (entity == null) {
            return;
        }
        if (entity.getPersistentData().getDouble("DespawnTime") >= 40.0) {
            if (!entity.level().isClientSide()) {
                entity.discard();
            }
        } else {
            entity.getPersistentData().putDouble("DespawnTime", entity.getPersistentData().getDouble("DespawnTime") + 1.0);
        }
        world.addParticle((ParticleOptions)ParticleTypes.END_ROD, entity.getX(), entity.getY(), entity.getZ(), 0.0, 1.0, 0.0);
        world.addParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH, entity.getX(), entity.getY(), entity.getZ(), 0.0, 1.0, 0.0);
        Vec3 _center = new Vec3(entity.getX(), entity.getY(), entity.getZ());
        for (Entity entityiterator : world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(0.5), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList()) {
            LivingEntity _entity;
            if (entityiterator instanceof StarBulletEntity || entityiterator instanceof Player || entityiterator instanceof RiftEntity || !(entityiterator instanceof LivingEntity)) continue;
            entity.setDeltaMovement(new Vec3((entityiterator.getX() - entity.getX()) / 0.5, entity.getDeltaMovement().y() - 0.1, (entityiterator.getZ() - entity.getZ()) / 0.5));
            entityiterator.hurt(new DamageSource(world.holderOrThrow(DamageTypes.GENERIC)), 30.0f);
            if (entityiterator instanceof LivingEntity && !(_entity = (LivingEntity)entityiterator).level().isClientSide()) {
                _entity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 100, 0, false, true));
            }
            if (entityiterator instanceof LivingEntity && !(_entity = (LivingEntity)entityiterator).level().isClientSide()) {
                _entity.addEffect(new MobEffectInstance(ArmageddonModModMobEffects.STUN, 20, 0, false, true));
            }
            if (entity.level().isClientSide()) continue;
            entity.discard();
        }
        if (world.getBlockState(BlockPos.containing((double)entity.getX(), (double)(entity.getY() - 0.1), (double)entity.getZ())).canOcclude() && !entity.level().isClientSide()) {
            entity.discard();
        }
    }
}

