/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.armageddonmod.item;

import java.util.List;
import net.mcreator.armageddonmod.init.ArmageddonModModItems;
import net.mcreator.armageddonmod.procedures.PrismaticSwordLivingEntityIsHitWithToolProcedure;
import net.mcreator.armageddonmod.procedures.PrismaticSwordToolInHandTickProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class PrismaticAxeItem
extends AxeItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 2145;
        }

        public float getSpeed() {
            return 10.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_DIAMOND_TOOL;
        }

        public int getEnchantmentValue() {
            return 10;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ArmageddonModModItems.ANCIENT_PRISM.get())});
        }
    };

    public PrismaticAxeItem() {
        super(TOOL_TIER, new Item.Properties().attributes(DiggerItem.createAttributes((Tier)TOOL_TIER, (float)10.0f, (float)-3.1f)).fireResistant());
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.hurtEnemy(itemstack, entity, sourceentity);
        PrismaticSwordLivingEntityIsHitWithToolProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, (Entity)sourceentity);
        return retval;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"item.armageddon_mod.prismatic_axe.description_0"));
        list.add((Component)Component.translatable((String)"item.armageddon_mod.prismatic_axe.description_1"));
        list.add((Component)Component.translatable((String)"item.armageddon_mod.prismatic_axe.description_2"));
        list.add((Component)Component.translatable((String)"item.armageddon_mod.prismatic_axe.description_3"));
        list.add((Component)Component.translatable((String)"item.armageddon_mod.prismatic_axe.description_4"));
        list.add((Component)Component.translatable((String)"item.armageddon_mod.prismatic_axe.description_5"));
        list.add((Component)Component.translatable((String)"item.armageddon_mod.prismatic_axe.description_6"));
        list.add((Component)Component.translatable((String)"item.armageddon_mod.prismatic_axe.description_7"));
        list.add((Component)Component.translatable((String)"item.armageddon_mod.prismatic_axe.description_8"));
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            PrismaticSwordToolInHandTickProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), entity);
        }
    }
}

