/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.armageddonmod.item;

import java.util.List;
import net.mcreator.armageddonmod.entity.TheTeleportationDaggerProjectileEntity;
import net.mcreator.armageddonmod.procedures.TheTelepotationDaggerRangedItemShootsProjectileProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TheTeleportationDaggerItem
extends Item {
    public TheTeleportationDaggerItem() {
        super(new Item.Properties().durability(10000).fireResistant().attributes(ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 10.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.4, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()));
    }

    public UseAnim getUseAnimation(ItemStack itemstack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 72000;
    }

    public float getDestroySpeed(ItemStack itemstack, BlockState state) {
        return 1.5f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"item.armageddon_mod.the_teleportation_dagger.description_0"));
        list.add((Component)Component.translatable((String)"item.armageddon_mod.the_teleportation_dagger.description_1"));
        list.add((Component)Component.translatable((String)"item.armageddon_mod.the_teleportation_dagger.description_2"));
        list.add((Component)Component.translatable((String)"item.armageddon_mod.the_teleportation_dagger.description_3"));
        list.add((Component)Component.translatable((String)"item.armageddon_mod.the_teleportation_dagger.description_4"));
        list.add((Component)Component.translatable((String)"item.armageddon_mod.the_teleportation_dagger.description_5"));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = InteractionResultHolder.fail((Object)entity.getItemInHand(hand));
        if (entity.getAbilities().instabuild || this.findAmmo(entity) != ItemStack.EMPTY) {
            ar = InteractionResultHolder.success((Object)entity.getItemInHand(hand));
            entity.startUsingItem(hand);
        }
        return ar;
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        itemstack.hurtAndBreak(1, entity, LivingEntity.getSlotForHand((InteractionHand)entity.getUsedItemHand()));
        return true;
    }

    public void releaseUsing(ItemStack itemstack, Level world, LivingEntity entity, int time) {
        if (!world.isClientSide() && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            float pullingPower = BowItem.getPowerForTime((int)(this.getUseDuration(itemstack, (LivingEntity)player) - time));
            if ((double)pullingPower < 0.1) {
                return;
            }
            ItemStack stack = this.findAmmo((Player)player);
            if (player.getAbilities().instabuild || stack != ItemStack.EMPTY) {
                TheTeleportationDaggerProjectileEntity projectile = TheTeleportationDaggerProjectileEntity.shoot(world, entity, world.getRandom(), pullingPower);
                itemstack.hurtAndBreak(1, entity, LivingEntity.getSlotForHand((InteractionHand)entity.getUsedItemHand()));
                if (player.getAbilities().instabuild) {
                    projectile.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                } else if (stack.isDamageableItem()) {
                    if (world instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)world;
                        stack.hurtAndBreak(1, serverLevel, player, _stkprov -> {});
                    }
                } else {
                    stack.shrink(1);
                }
                TheTelepotationDaggerRangedItemShootsProjectileProcedure.execute((Entity)entity, itemstack);
            }
        }
    }

    private ItemStack findAmmo(Player player) {
        return new ItemStack((ItemLike)TheTeleportationDaggerProjectileEntity.PROJECTILE_ITEM.getItem());
    }
}

