/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.armageddonmod.network;

import java.util.function.Supplier;
import net.mcreator.armageddonmod.ArmageddonModMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class ArmageddonModModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"armageddon_mod");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        ArmageddonModMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        ArmageddonModMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"armageddon_mod", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"armageddon_mod", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public boolean IndomitaFuria = false;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putBoolean("IndomitaFuria", this.IndomitaFuria);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.IndomitaFuria = nbt.getBoolean("IndomitaFuria");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "armageddon_mod_mapvars";
        public boolean AntiquePendantVariable = true;
        public boolean apprentice_armor_equipped = true;
        public boolean ArionsHeartVariable = true;
        public boolean ColossalShieldVariable = true;
        public boolean GoldenShacklesVariable = true;
        public boolean novice_boots_equipped = false;
        public boolean novice_builder_armor_set_bonus = true;
        public boolean novice_chestplate_equipped = false;
        public boolean novice_helmet_equipped = false;
        public boolean novice_leggings_equipped = false;
        public boolean petgoblin = true;
        public boolean WitherSpineVariable = true;
        public boolean ZoranthHandVariable = true;
        public boolean expert_armor_equipped = true;
        public double ChaosSonicBoomTimer = 0.0;
        public boolean HarmodeStart = false;
        public boolean HoldingHollowPickaxe = false;
        public boolean HoldingHollowShovel = false;
        public boolean HoldingHollowAxe = false;
        public double holy_stack = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.AntiquePendantVariable = nbt.getBoolean("AntiquePendantVariable");
            this.apprentice_armor_equipped = nbt.getBoolean("apprentice_armor_equipped");
            this.ArionsHeartVariable = nbt.getBoolean("ArionsHeartVariable");
            this.ColossalShieldVariable = nbt.getBoolean("ColossalShieldVariable");
            this.GoldenShacklesVariable = nbt.getBoolean("GoldenShacklesVariable");
            this.novice_boots_equipped = nbt.getBoolean("novice_boots_equipped");
            this.novice_builder_armor_set_bonus = nbt.getBoolean("novice_builder_armor_set_bonus");
            this.novice_chestplate_equipped = nbt.getBoolean("novice_chestplate_equipped");
            this.novice_helmet_equipped = nbt.getBoolean("novice_helmet_equipped");
            this.novice_leggings_equipped = nbt.getBoolean("novice_leggings_equipped");
            this.petgoblin = nbt.getBoolean("petgoblin");
            this.WitherSpineVariable = nbt.getBoolean("WitherSpineVariable");
            this.ZoranthHandVariable = nbt.getBoolean("ZoranthHandVariable");
            this.expert_armor_equipped = nbt.getBoolean("expert_armor_equipped");
            this.ChaosSonicBoomTimer = nbt.getDouble("ChaosSonicBoomTimer");
            this.HarmodeStart = nbt.getBoolean("HarmodeStart");
            this.HoldingHollowPickaxe = nbt.getBoolean("HoldingHollowPickaxe");
            this.HoldingHollowShovel = nbt.getBoolean("HoldingHollowShovel");
            this.HoldingHollowAxe = nbt.getBoolean("HoldingHollowAxe");
            this.holy_stack = nbt.getDouble("holy_stack");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putBoolean("AntiquePendantVariable", this.AntiquePendantVariable);
            nbt.putBoolean("apprentice_armor_equipped", this.apprentice_armor_equipped);
            nbt.putBoolean("ArionsHeartVariable", this.ArionsHeartVariable);
            nbt.putBoolean("ColossalShieldVariable", this.ColossalShieldVariable);
            nbt.putBoolean("GoldenShacklesVariable", this.GoldenShacklesVariable);
            nbt.putBoolean("novice_boots_equipped", this.novice_boots_equipped);
            nbt.putBoolean("novice_builder_armor_set_bonus", this.novice_builder_armor_set_bonus);
            nbt.putBoolean("novice_chestplate_equipped", this.novice_chestplate_equipped);
            nbt.putBoolean("novice_helmet_equipped", this.novice_helmet_equipped);
            nbt.putBoolean("novice_leggings_equipped", this.novice_leggings_equipped);
            nbt.putBoolean("petgoblin", this.petgoblin);
            nbt.putBoolean("WitherSpineVariable", this.WitherSpineVariable);
            nbt.putBoolean("ZoranthHandVariable", this.ZoranthHandVariable);
            nbt.putBoolean("expert_armor_equipped", this.expert_armor_equipped);
            nbt.putDouble("ChaosSonicBoomTimer", this.ChaosSonicBoomTimer);
            nbt.putBoolean("HarmodeStart", this.HarmodeStart);
            nbt.putBoolean("HoldingHollowPickaxe", this.HoldingHollowPickaxe);
            nbt.putBoolean("HoldingHollowShovel", this.HoldingHollowShovel);
            nbt.putBoolean("HoldingHollowAxe", this.HoldingHollowAxe);
            nbt.putDouble("holy_stack", this.holy_stack);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "armageddon_mod_worldvars";
        public double IronColossusTimer = 0.0;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.IronColossusTimer = nbt.getDouble("IronColossusTimer");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("IronColossusTimer", this.IronColossusTimer);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.IndomitaFuria = original.IndomitaFuria;
            if (!event.isWasDeath()) {
                // empty if block
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

