/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.armageddonmod.procedures;

import java.util.Comparator;
import net.mcreator.armageddonmod.entity.PassiveBloodSlashEntity;
import net.mcreator.armageddonmod.init.ArmageddonModModMobEffects;
import net.mcreator.armageddonmod.init.ArmageddonModModParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PassiveBloodSlashOnEntityTickUpdateProcedure {
    public static void execute(LevelAccessor world, Entity entity) {
        ServerLevel _level;
        if (entity == null) {
            return;
        }
        if (entity.getPersistentData().getDouble("DespawnTime") >= 60.0) {
            if (!entity.level().isClientSide()) {
                entity.discard();
            }
        } else {
            entity.getPersistentData().putDouble("DespawnTime", entity.getPersistentData().getDouble("DespawnTime") + 1.0);
        }
        if (world instanceof ServerLevel) {
            _level = (ServerLevel)world;
            _level.sendParticles((ParticleOptions)((SimpleParticleType)ArmageddonModModParticleTypes.BLOOD_DROPLETS.get()), entity.getX(), entity.getY(), entity.getZ(), 3, 2.0, 1.0, 2.0, 0.2);
        }
        if (world instanceof ServerLevel) {
            _level = (ServerLevel)world;
            _level.sendParticles((ParticleOptions)((SimpleParticleType)ArmageddonModModParticleTypes.BLOODY_FEATHERS.get()), entity.getX(), entity.getY(), entity.getZ(), 3, 2.0, 1.0, 2.0, 0.2);
        }
        entity.setDeltaMovement(new Vec3(entity.getDeltaMovement().x() + entity.getLookAngle().x * 0.1, entity.getLookAngle().y, entity.getDeltaMovement().z() + entity.getLookAngle().z * 0.1));
        Vec3 _center = new Vec3(entity.getX(), entity.getY(), entity.getZ());
        for (Entity entityiterator : world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(3.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList()) {
            LivingEntity _entity;
            if (entityiterator instanceof Player || entityiterator instanceof PassiveBloodSlashEntity || !(entityiterator instanceof LivingEntity)) continue;
            if (entityiterator instanceof LivingEntity && !(_entity = (LivingEntity)entityiterator).level().isClientSide()) {
                _entity.addEffect(new MobEffectInstance(ArmageddonModModMobEffects.HEMORRHAGE, 200, 0, false, false));
            }
            entityiterator.hurt(new DamageSource(world.holderOrThrow(DamageTypes.MOB_ATTACK), entity), 50.0f);
        }
    }
}

