/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import phanastrae.operation_starcleave.block.OperationStarcleaveBlocks;
import phanastrae.operation_starcleave.entity.OperationStarcleaveDamageTypes;
import phanastrae.operation_starcleave.particle.OperationStarcleaveParticleTypes;
import phanastrae.operation_starcleave.registry.OperationStarcleaveFluidTags;

public abstract class AbstractPetrichoricBlock
extends Block {
    public AbstractPetrichoricBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public boolean skipRendering(BlockState state, BlockState stateFrom, Direction direction) {
        return stateFrom.is((Block)this);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        block2: {
            block3: {
                entity.makeStuckInBlock(state, new Vec3(0.85, 0.5, 0.85));
                if (!entity.hurt(OperationStarcleaveDamageTypes.source(level, OperationStarcleaveDamageTypes.IN_PHLOGISTIC_FIRE), 12.0f)) break block2;
                if (!(entity instanceof Player)) break block3;
                Player player = (Player)entity;
                if (player.getAbilities().invulnerable && player.getAbilities().flying) break block2;
            }
            RandomSource random = level.getRandom();
            entity.push((double)random.nextFloat() * 0.8 - 0.4, (double)random.nextFloat() * 0.3 + 0.6, (double)random.nextFloat() * 0.8 - 0.4);
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (level.getBlockState(pos.above()).isAir()) {
            double x = (double)pos.getX() + random.nextDouble();
            double y = (double)pos.getY() + random.nextDouble() * 0.2 + 0.8;
            double z = (double)pos.getZ() + random.nextDouble();
            level.addParticle((ParticleOptions)OperationStarcleaveParticleTypes.LARGE_GLIMMER_SMOKE, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static boolean absorbWater(Level level, BlockPos pos, RandomSource random) {
        int posY = pos.getY();
        return BlockPos.breadthFirstTraversal((BlockPos)pos, (int)2, (int)65, (currentPos, queuer) -> {
            for (Direction direction : UPDATE_SHAPE_ORDER) {
                queuer.accept(currentPos.relative(direction));
            }
        }, currentPos -> {
            BucketPickup fluidDrainable;
            BlockState newState;
            int yDif = currentPos.getY() - posY;
            BlockState filler = OperationStarcleaveBlocks.PLASMA_ICE.defaultBlockState();
            BlockState vapor = OperationStarcleaveBlocks.PETRICHORIC_VAPOR.defaultBlockState();
            BlockState blockState = newState = yDif <= 0 ? filler : vapor;
            if (currentPos.equals((Object)pos)) {
                return true;
            }
            BlockState blockState2 = level.getBlockState(currentPos);
            FluidState fluidState = level.getFluidState(currentPos);
            if (fluidState.isEmpty() || fluidState.is(OperationStarcleaveFluidTags.PETRICHORIC_PLASMA)) {
                return false;
            }
            Block block = blockState2.getBlock();
            if (block instanceof LiquidBlock) {
                BlockState st = fluidState.isSource() ? newState : vapor;
                level.setBlock(currentPos, st, 3);
                if (st.is(OperationStarcleaveBlocks.PLASMA_ICE)) {
                    level.scheduleTick(currentPos, newState.getBlock(), random.nextInt(2) + 1);
                }
                return true;
            }
            if (block instanceof BucketPickup && !(fluidDrainable = (BucketPickup)block).pickupBlock(null, (LevelAccessor)level, currentPos, blockState2).isEmpty()) {
                return true;
            }
            if (blockState2.is(Blocks.KELP) || blockState2.is(Blocks.KELP_PLANT) || blockState2.is(Blocks.SEAGRASS) || blockState2.is(Blocks.TALL_SEAGRASS)) {
                BlockEntity blockEntity = blockState2.hasBlockEntity() ? level.getBlockEntity(currentPos) : null;
                AbstractPetrichoricBlock.dropResources((BlockState)blockState2, (LevelAccessor)level, (BlockPos)currentPos, (BlockEntity)blockEntity);
                level.setBlock(currentPos, newState, 3);
                if (newState.is(OperationStarcleaveBlocks.PLASMA_ICE)) {
                    level.scheduleTick(currentPos, newState.getBlock(), random.nextInt(2) + 1);
                }
                return true;
            }
            return false;
        }) > 1;
    }
}

