/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import phanastrae.operation_starcleave.block.NucleosyntheseedBlock;
import phanastrae.operation_starcleave.block.OperationStarcleaveBlocks;
import phanastrae.operation_starcleave.particle.OperationStarcleaveParticleTypes;

public class NucleicFissurerootBlock
extends RotatedPillarBlock {
    public static final MapCodec<NucleicFissurerootBlock> CODEC = NucleicFissurerootBlock.simpleCodec(NucleicFissurerootBlock::new);

    public NucleicFissurerootBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS);
        BlockPos adjPos = pos.relative(switch (axis) {
            case Direction.Axis.X -> random.nextBoolean() ? Direction.EAST : Direction.WEST;
            case Direction.Axis.Z -> random.nextBoolean() ? Direction.NORTH : Direction.SOUTH;
            default -> random.nextBoolean() ? Direction.UP : Direction.DOWN;
        });
        BlockState adjState = level.getBlockState(adjPos);
        if (adjState.is(OperationStarcleaveBlocks.NUCLEOSYNTHESEED)) {
            NucleosyntheseedBlock.trySpread(adjState, level, adjPos, random, false);
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.nextInt(4) == 0) {
            for (Direction direction : Direction.values()) {
                BlockPos adjPos = pos.relative(direction);
                BlockState adjState = level.getBlockState(adjPos);
                if (adjState.isFaceSturdy((BlockGetter)level, pos, direction.getOpposite())) continue;
                for (int i = 0; i < 1 + random.nextInt(2); ++i) {
                    level.addParticle((ParticleOptions)OperationStarcleaveParticleTypes.PLASMA_DUST, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, random.nextGaussian() * 0.05, random.nextGaussian() * 0.05, random.nextGaussian() * 0.05);
                }
            }
        }
    }
}

